/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.serviio.upnp.Device;
import org.serviio.upnp.discovery.AbstractSSDPMessageListener;
import org.serviio.upnp.discovery.RendererSearchResponseProcessor;
import org.serviio.upnp.protocol.http.HttpMessageParser;
import org.serviio.upnp.protocol.ssdp.SSDPMessageBuilderFactory;
import org.serviio.util.HttpUtils;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.NicIP;
import org.serviio.util.ServiioThreadFactory;
import org.serviio.util.ThreadExecutor;

public class RendererSearchSender
extends AbstractSSDPMessageListener {
    private int mx;
    private int searchSendCount;

    public RendererSearchSender(int mx, int searchSendCount) {
        this.mx = mx;
        this.searchSendCount = searchSendCount;
    }

    public void searchForRenderers() throws IOException {
        NicIP iface = this.getBoundNIC();
        this.log.info(String.format("Searching for Renderer devices", new Object[0]));
        Thread t = ServiioThreadFactory.getInstance().newThread(new RendererSearchWorker(iface));
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.debug("Finished searching for Renderer devices");
    }

    private class RendererSearchWorker
    extends AbstractSSDPMessageListener
    implements Runnable {
        private NicIP multicastInterface;

        public RendererSearchWorker(NicIP multicastInterface) {
            this.multicastInterface = multicastInterface;
        }

        @Override
        public void run() {
            try {
                this.sendSearchToSingleInterface(this.multicastInterface);
            }
            catch (IOException e) {
                this.log.warn(String.format("Search for Renderers using interface %s failed: %s", MultiCastUtils.getInterfaceName(this.multicastInterface.getNic()), e.getMessage()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSearchToSingleInterface(NicIP multicastInterface) throws IOException {
            MulticastSocket socket = null;
            Device device = Device.getInstance();
            InetAddress address = multicastInterface.getIp();
            if (address != null) {
                try {
                    socket = MultiCastUtils.startMultiCastSocketForSending(multicastInterface.getNic(), address, 32);
                    if (socket != null && socket.isBound()) {
                        this.log.debug(String.format("Multicasting SSDP M-SEARCH using interface %s and address %s, timeout = %s", MultiCastUtils.getInterfaceName(multicastInterface.getNic()), address.getHostAddress(), socket.getSoTimeout()));
                        List<String> messages = SSDPMessageBuilderFactory.getInstance().getBuilder(SSDPMessageBuilderFactory.SSDPMessageType.SEARCH).generateSSDPMessages(RendererSearchSender.this.mx, "urn:schemas-upnp-org:device:MediaRenderer:1");
                        this.log.debug(String.format("Sending %s 'm-search' messages", messages.size()));
                        for (String message : messages) {
                            for (int i = 0; i < RendererSearchSender.this.searchSendCount; ++i) {
                                MultiCastUtils.send(message, socket, device.getMulticastGroupAddress());
                            }
                        }
                        this.waitForResponses(socket, RendererSearchSender.this.mx + 2);
                    } else {
                        this.log.warn("Cannot multicast SSDP M-SEARCH message. Not connected to a socket.");
                    }
                }
                finally {
                    MultiCastUtils.stopMultiCastSocket(socket, device.getMulticastGroupAddress(), false);
                }
            }
        }

        private void waitForResponses(MulticastSocket socket, int mx) {
            long startTime = System.currentTimeMillis();
            int remainingTimeout = 1;
            while (remainingTimeout > 0) {
                remainingTimeout = mx * 1000 - new Long(System.currentTimeMillis() - startTime).intValue();
                if (remainingTimeout <= 0) continue;
                try {
                    socket.setSoTimeout(remainingTimeout);
                    DatagramPacket receivedPacket = MultiCastUtils.receive(socket);
                    HttpResponse response = HttpMessageParser.parseHttpResponse(MultiCastUtils.getPacketData(receivedPacket));
                    if (response.getStatusLine().getStatusCode() == 200) {
                        this.processSearchResponse(response, receivedPacket);
                        continue;
                    }
                    this.log.debug("Received HTTP error " + response.getStatusLine().getStatusCode());
                }
                catch (HttpException e) {
                    this.log.debug("Received message is not HTTP message");
                }
                catch (SocketTimeoutException e) {
                    remainingTimeout = -1;
                }
                catch (IOException e) {
                    this.log.debug("Cannot receive HTTP message: " + e.getMessage());
                }
            }
        }

        private void processSearchResponse(HttpResponse response, DatagramPacket receivedPacket) {
            Header headerCacheControl = response.getFirstHeader("CACHE-CONTROL");
            Header headerLocation = response.getFirstHeader("LOCATION");
            Header headerST = response.getFirstHeader("ST");
            Header headerSERVER = response.getFirstHeader("SERVER");
            Header headerUSN = response.getFirstHeader("USN");
            this.log.debug(String.format("Received search response: location: %s, st: %s", headerLocation.getValue(), headerST.getValue()));
            if (headerST != null && headerST.getValue().equals("urn:schemas-upnp-org:device:MediaRenderer:1") && headerUSN != null && headerSERVER != null) {
                try {
                    String descriptionURL;
                    String server = headerSERVER.getValue().trim();
                    String deviceUuid = this.getDeviceUuidFromUSN(headerUSN.getValue());
                    String string = descriptionURL = headerLocation != null ? headerLocation.getValue() : null;
                    if (deviceUuid != null) {
                        int timeToKeep = HttpUtils.getMaxAgeFromHeader(headerCacheControl);
                        String deviceIP = this.getDeviceIPAddress(descriptionURL, receivedPacket.getSocketAddress());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.format("Received a valid M-SEARCH response from Renderer %s from address %s", deviceUuid, deviceIP));
                        }
                        ThreadExecutor.execute(new RendererSearchResponseProcessor(deviceIP, deviceUuid, server, timeToKeep, descriptionURL));
                    } else {
                        this.log.warn(String.format("Provided USN value is invalid: %s. Will not process the search reply.", headerUSN.getValue()));
                    }
                }
                catch (NumberFormatException e) {
                    this.log.warn(String.format("Invalid header value: %s. Will not respond to the request.", e.getMessage()));
                }
            }
        }
    }
}

