/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import org.serviio.renderer.RendererManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererAdvertisementProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RendererAdvertisementProcessor.class);
    private String deviceIPAddress;
    private String nts;
    private int timeToKeep;
    private String deviceDescriptionURL;
    private String uuid;
    private String server;

    public RendererAdvertisementProcessor(String deviceIPAddress, String uuid, String nts, int timeToKeep, String deviceDescriptionURL, String server) {
        this.deviceIPAddress = deviceIPAddress;
        this.uuid = uuid;
        this.nts = nts;
        this.timeToKeep = timeToKeep;
        this.deviceDescriptionURL = deviceDescriptionURL;
        this.server = server;
    }

    @Override
    public void run() {
        if (this.nts.equals("ssdp:alive")) {
            RendererManager.getInstance().rendererAvailable(this.uuid, this.deviceIPAddress, this.timeToKeep, this.deviceDescriptionURL, this.server);
        } else if (this.nts.equals("ssdp:byebye")) {
            RendererManager.getInstance().rendererUnavailable(this.uuid);
        } else {
            log.debug(String.format("Invalid NTS in NOTIFY message: %s", this.nts));
        }
    }
}

