/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import java.io.IOException;
import org.serviio.upnp.Device;
import org.serviio.upnp.discovery.DiscoveryManager;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.NicIP;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Multicaster {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected synchronized NicIP getBoundNIC() throws IOException {
        try {
            Tupple<NicIP, Boolean> nicIpResult = MultiCastUtils.findNicIPWithRetry(Device.getInstance().getBindAddress());
            if (nicIpResult.getValueB().booleanValue()) {
                DiscoveryManager.instance().restartDiscoveryEngine();
            }
            return nicIpResult.getValueA();
        }
        catch (IOException e) {
            this.log.warn(String.format("Cannot acquire NIC for current bound IP address %s, will re-acquire new IP", Device.getInstance().getBindAddress().getHostAddress()));
            DiscoveryManager.instance().restartDiscoveryEngine();
            return MultiCastUtils.findNicIP(Device.getInstance().getBindAddress());
        }
    }
}

