/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.List;
import org.serviio.upnp.protocol.ssdp.SearchResponseMessageBuilder;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.NumberUtils;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverySearchResponder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DiscoverySearchResponder.class);
    private static final int MAX_MX = 120;
    private int advertisementDuration;
    private SocketAddress sourceAddress;
    private int timeToRespond;
    private String searchTarget;

    public DiscoverySearchResponder(SocketAddress sourceAddress, int advertisementDuration, int timeToRespond, String searchTarget) {
        this.advertisementDuration = advertisementDuration;
        this.sourceAddress = sourceAddress;
        this.timeToRespond = timeToRespond;
        this.searchTarget = searchTarget;
    }

    @Override
    public void run() {
        List<String> messages;
        if (this.timeToRespond >= 1 && this.searchTarget != null && (messages = this.generateMessages()).size() > 0) {
            log.debug(String.format("Sending %s M-SEARCH response message(s) to %s", messages.size(), this.sourceAddress));
            this.sendReply(messages);
        }
    }

    protected List<String> generateMessages() {
        SearchResponseMessageBuilder builder = new SearchResponseMessageBuilder();
        return builder.generateSSDPMessages(this.advertisementDuration, this.searchTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReply(List<String> messages) {
        DatagramSocket socket = null;
        int messageTimeout = this.getTimeToRespond(messages);
        try {
            socket = MultiCastUtils.startUniCastSocket();
            if (socket != null && socket.isBound()) {
                for (String message : messages) {
                    ThreadUtils.currentThreadSleep(NumberUtils.getRandomInInterval(0, messageTimeout * 1000));
                    MultiCastUtils.send(message, socket, this.sourceAddress);
                }
            } else {
                log.warn("Cannot respond to SSDP M-SEARCH message. Not connected to a socket.");
            }
        }
        catch (SocketTimeoutException ex) {
            log.debug("Socket timed out: " + ex.getMessage() + ", response will not be sent");
        }
        catch (IOException e) {
            log.warn("Problem during DiscoverySearchResponder, response will not be sent", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Fatal error during DiscoverySearchResponder, response will not be sent", (Throwable)e);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    private int getTimeToRespond(List<String> messages) {
        if (this.timeToRespond > 120) {
            this.timeToRespond = 120;
        }
        int mx = this.timeToRespond / messages.size();
        return mx;
    }
}

