/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.serviio.upnp.Device;
import org.serviio.upnp.discovery.AbstractSSDPMessageListener;
import org.serviio.upnp.discovery.DiscoverySearchResponder;
import org.serviio.upnp.discovery.RendererAdvertisementProcessor;
import org.serviio.upnp.protocol.http.HttpMessageParser;
import org.serviio.util.HttpUtils;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.NicIP;
import org.serviio.util.ThreadExecutor;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverySSDPMessageListener
extends AbstractSSDPMessageListener
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DiscoverySSDPMessageListener.class);
    private boolean workerRunning = false;
    private MulticastSocket socket;
    private int advertisementDuration;

    public DiscoverySSDPMessageListener(int advertisementDuration) {
        this.advertisementDuration = advertisementDuration;
    }

    @Override
    public void run() {
        while (!this.workerRunning) {
            try {
                NicIP iface = this.getBoundNIC();
                this.socket = MultiCastUtils.startMultiCastSocketForListening(Device.getInstance().getMulticastGroupAddress(), iface.getNic(), 4);
                log.info(String.format("Starting DiscoverySSDPMessageListener using interface %s and address %s, timeout = %s", MultiCastUtils.getInterfaceName(iface.getNic()), iface.getIp().getHostAddress(), this.socket.getSoTimeout()));
                this.workerRunning = true;
            }
            catch (IOException e) {
                log.error("Cannot open multicast socket,will try again", (Throwable)e);
                ThreadUtils.currentThreadSleep(1000L);
            }
        }
        while (this.workerRunning) {
            try {
                this.listenForMulticastMessages();
            }
            catch (SocketTimeoutException ex) {
                log.debug("Socket timed out: " + ex.getMessage() + ", will try again");
            }
            catch (SocketException ex) {
                log.debug("Socket closed: " + ex.getMessage());
            }
            catch (IOException e) {
                log.warn("Problem during DiscoverySSDPMessageListener, will try again", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Unexpected error during DiscoverySSDPMessageListener, will try again", (Throwable)e);
            }
        }
        log.info("Leaving DiscoverySSDPMessageListener");
    }

    public void stopWorker() {
        MultiCastUtils.stopMultiCastSocket(this.socket, Device.getInstance().getMulticastGroupAddress(), true);
        this.workerRunning = false;
    }

    protected void listenForMulticastMessages() throws IOException {
        DatagramPacket receivedPacket = MultiCastUtils.receive(this.socket);
        try {
            HttpRequest request = HttpMessageParser.parseHttpRequest(MultiCastUtils.getPacketData(receivedPacket));
            if (request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
                if (request.getRequestLine().getMethod().equals("M-SEARCH") && request.getRequestLine().getUri().equals("*")) {
                    this.processSearchMessage(request, receivedPacket);
                } else if (request.getRequestLine().getMethod().equals("NOTIFY") && request.getRequestLine().getUri().equals("*")) {
                    this.processNotifyMessage(request, receivedPacket);
                }
            } else {
                log.debug("Received message is not HTTP 1.1");
            }
        }
        catch (HttpException e) {
            log.debug("Received message is not HTTP message");
        }
    }

    protected void processSearchMessage(HttpRequest request, DatagramPacket receivedPacket) {
        Header headerMAN = request.getFirstHeader("MAN");
        Header headerMX = request.getFirstHeader("MX");
        Header headerST = request.getFirstHeader("ST");
        if (headerMAN != null && headerMAN.getValue().equals("\"ssdp:discover\"") && headerMX != null && headerMX.getValue().trim().length() > 0) {
            try {
                String searchTarget;
                int timeToRespond = Integer.valueOf(headerMX.getValue());
                String string = searchTarget = headerST != null ? headerST.getValue() : null;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Received a valid M-SEARCH message for search target %s from address %ss", searchTarget, receivedPacket.getSocketAddress().toString()));
                }
                ThreadExecutor.execute(new DiscoverySearchResponder(receivedPacket.getSocketAddress(), this.advertisementDuration, timeToRespond, searchTarget));
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Provided MX value is invalid: %s. Will not respond to the request.", headerMX.getValue()));
            }
        } else {
            log.debug("The message is not a valid M-SEARCH request");
        }
    }

    protected void processNotifyMessage(HttpRequest request, DatagramPacket receivedPacket) {
        Header headerCacheControl = request.getFirstHeader("CACHE-CONTROL");
        Header headerLocation = request.getFirstHeader("LOCATION");
        Header headerNT = request.getFirstHeader("NT");
        Header headerNTS = request.getFirstHeader("NTS");
        Header headerUSN = request.getFirstHeader("USN");
        Header headerSERVER = request.getFirstHeader("SERVER");
        if (headerNT != null && headerNT.getValue().equals("urn:schemas-upnp-org:device:MediaRenderer:1") && headerUSN != null && headerNTS != null) {
            try {
                String server;
                String nts = headerNTS.getValue().trim();
                String deviceUuid = this.getDeviceUuidFromUSN(headerUSN.getValue());
                String descriptionURL = headerLocation != null ? headerLocation.getValue() : null;
                String string = server = headerSERVER != null ? headerSERVER.getValue().trim() : null;
                if (deviceUuid != null) {
                    int timeToKeep = HttpUtils.getMaxAgeFromHeader(headerCacheControl);
                    String deviceIP = this.getDeviceIPAddress(descriptionURL, receivedPacket.getSocketAddress());
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Received a valid NOTIFY (%s) message from Renderer %s from address %s", nts, deviceUuid, deviceIP));
                    }
                    ThreadExecutor.execute(new RendererAdvertisementProcessor(deviceIP, deviceUuid, nts, timeToKeep, descriptionURL, server));
                } else {
                    log.warn(String.format("Provided USN value is invalid: %s. Will not respond to the request.", headerUSN.getValue()));
                }
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Invalid header value: %s. Will not respond to the request.", e.getMessage()));
            }
        }
    }
}

