/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.serviio.upnp.Device;
import org.serviio.upnp.discovery.Multicaster;
import org.serviio.upnp.protocol.ssdp.SSDPMessageBuilderFactory;
import org.serviio.util.DateUtils;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.NicIP;
import org.serviio.util.NumberUtils;
import org.serviio.util.ThreadUtils;

public class DiscoveryAdvertisementNotifier
extends Multicaster
implements Runnable {
    private static final int INITIAL_ADV_DELAY = 10000;
    private int advertisementDuration;
    private int advertisementSendCount;
    private boolean workerRunning = false;
    private int aliveSentCounter = 0;

    public DiscoveryAdvertisementNotifier(int advertisementDuration, int advertisementSendCount) {
        this.advertisementDuration = advertisementDuration;
        this.advertisementSendCount = advertisementSendCount;
    }

    @Override
    public void run() {
        this.log.info("Starting DiscoveryAdvertisementNotifier");
        ThreadUtils.currentThreadSleep(NumberUtils.getRandomInInterval(0, 100));
        this.workerRunning = true;
        while (this.workerRunning) {
            try {
                long sendStart = System.currentTimeMillis();
                boolean sent = this.sendAlive();
                if (sent) {
                    long sendDuration = System.currentTimeMillis() - sendStart;
                    long delay = this.aliveSentCounter < 3 ? 10000L : (long)NumberUtils.getRandomInInterval(this.advertisementDuration * 1000 / 10, this.advertisementDuration * 1000 / 7);
                    this.log.debug(String.format("Will advertise again in %s (advertisement duration is %s sec.)", DateUtils.timeToHHMMSS(delay -= sendDuration), this.advertisementDuration));
                    ThreadUtils.currentThreadSleep(Math.max(0L, delay));
                    continue;
                }
                this.log.warn("Could not advertise the device on any available NIC, will try again");
                ThreadUtils.currentThreadSleep(5000L);
            }
            catch (SocketException e) {
                this.log.warn("Problem during retrieving list on NetworkInterfaces, will try again", (Throwable)e);
                ThreadUtils.currentThreadSleep(5000L);
            }
            catch (Exception e) {
                this.log.error("Fatal error during DiscoveryAdvertisementNotifier, thread will exit", (Throwable)e);
                this.workerRunning = false;
            }
        }
        this.log.info("Leaving DiscoveryAdvertisementNotifier");
    }

    public boolean sendAlive() throws SocketException {
        NicIP iface = null;
        try {
            iface = this.getBoundNIC();
            this.sendAliveToSingleInterface(iface);
            ++this.aliveSentCounter;
            return true;
        }
        catch (SocketTimeoutException ex) {
            this.log.debug("Socket timed out when sending to " + iface.toString() + ": " + ex.getMessage() + ", will try again");
        }
        catch (IOException e) {
            this.log.debug("Problem during DiscoveryAdvertisementNotifier, will try again", (Throwable)e);
        }
        return false;
    }

    public void sendByeBye() throws SocketException {
        try {
            NicIP iface = this.getBoundNIC();
            this.sendByeByeToSingleInterface(iface);
        }
        catch (IOException e) {
            this.log.warn("Problem sending bye-bye: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stopWorker() {
        this.workerRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAliveToSingleInterface(NicIP multicastInterface) throws IOException {
        MulticastSocket socket = null;
        Device device = Device.getInstance();
        InetAddress address = multicastInterface.getIp();
        if (address != null) {
            try {
                socket = MultiCastUtils.startMultiCastSocketForSending(multicastInterface.getNic(), address, 32);
                if (socket != null && socket.isBound()) {
                    this.log.debug(String.format("Multicasting SSDP alive using interface %s and address %s, timeout = %s", MultiCastUtils.getInterfaceName(multicastInterface.getNic()), address.getHostAddress(), socket.getSoTimeout()));
                    List<String> messages = SSDPMessageBuilderFactory.getInstance().getBuilder(SSDPMessageBuilderFactory.SSDPMessageType.ALIVE).generateSSDPMessages(this.advertisementDuration, null);
                    this.log.debug(String.format("Sending %s 'alive' messages describing device %s", messages.size(), device.getUuid()));
                    for (String message : messages) {
                        for (int i = 0; i < this.advertisementSendCount; ++i) {
                            MultiCastUtils.send(message, socket, device.getMulticastGroupAddress());
                            ThreadUtils.currentThreadSleep(100L);
                        }
                    }
                } else {
                    this.log.warn("Cannot multicast SSDP alive message. Not connected to a socket.");
                }
            }
            finally {
                MultiCastUtils.stopMultiCastSocket(socket, device.getMulticastGroupAddress(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendByeByeToSingleInterface(NicIP multicastInterface) throws IOException {
        MulticastSocket socket = null;
        Device device = Device.getInstance();
        InetAddress address = multicastInterface.getIp();
        if (address != null) {
            try {
                socket = MultiCastUtils.startMultiCastSocketForSending(multicastInterface.getNic(), address, 32);
                if (socket != null && socket.isBound()) {
                    this.log.debug(String.format("Multicasting SSDP byebye using interface %s and address %s, timeout = %s", MultiCastUtils.getInterfaceName(multicastInterface.getNic()), address.getHostAddress(), socket.getSoTimeout()));
                    List<String> messages = SSDPMessageBuilderFactory.getInstance().getBuilder(SSDPMessageBuilderFactory.SSDPMessageType.BYEBYE).generateSSDPMessages(null, null);
                    for (String message : messages) {
                        for (int i = 0; i < this.advertisementSendCount; ++i) {
                            MultiCastUtils.send(message, socket, device.getMulticastGroupAddress());
                        }
                    }
                } else {
                    this.log.warn("Cannot multicast SSDP byebye message. Not connected to a socket.");
                }
            }
            finally {
                MultiCastUtils.stopMultiCastSocket(socket, device.getMulticastGroupAddress(), false);
            }
        }
    }
}

