/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.upnp.discovery.Multicaster;
import org.serviio.util.StringUtils;

public abstract class AbstractSSDPMessageListener
extends Multicaster {
    private static final Pattern usnPattern = Pattern.compile("uuid:(.+)::urn:.+", 2);

    protected String getDeviceUuidFromUSN(String usn) {
        Matcher m;
        if (usn != null && (m = usnPattern.matcher(usn)).find()) {
            return StringUtils.localeSafeToLowercase(m.group(1));
        }
        return null;
    }

    protected String getDeviceIPAddress(String descriptionURL, SocketAddress fallbackSocketAddress) {
        if (descriptionURL == null) {
            return this.getIPFromSocketAddress(fallbackSocketAddress);
        }
        try {
            InetAddress address = InetAddress.getByName(new URL(descriptionURL).getHost());
            return address.getHostAddress();
        }
        catch (Exception e) {
            return this.getIPFromSocketAddress(fallbackSocketAddress);
        }
    }

    private String getIPFromSocketAddress(SocketAddress address) {
        return ((InetSocketAddress)address).getAddress().getHostAddress();
    }
}

