/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.update;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPathExpressionException;
import org.serviio.ApplicationSettings;
import org.serviio.MediaServer;
import org.serviio.util.HttpClient;
import org.serviio.util.Platform;
import org.serviio.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class UpdateChecker {
    private static final Logger log = LoggerFactory.getLogger(UpdateChecker.class);
    private static final String XML_URL = ApplicationSettings.getStringProperty("update_url");
    private static final int VERSION_CHECKER_INTERVAL_HOURS = 24;
    private static String availableNewVersion = null;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void startCheckerThread() {
        Runnable checker = new Runnable(){

            @Override
            public void run() {
                UpdateChecker.checkForUpdate();
            }
        };
        scheduler.scheduleAtFixedRate(checker, 0L, 24L, TimeUnit.HOURS);
    }

    public static String getNewAvailableVersion() {
        return availableNewVersion;
    }

    private static void checkForUpdate() {
        log.info("Checking if a new version is available");
        try {
            String xml = HttpClient.retrieveTextFileFromURL(XML_URL, "UTF-8");
            if (xml != null) {
                availableNewVersion = UpdateChecker.runCheck(new ByteArrayInputStream(xml.getBytes()), MediaServer.VERSION);
                return;
            }
        }
        catch (FileNotFoundException e) {
            log.debug("Cannot find the update XML file. Message: " + e.getMessage());
        }
        catch (IOException e) {
            log.debug("Cannot retrieve the update XML file. Message: " + e.getMessage());
        }
        availableNewVersion = null;
    }

    protected static boolean versionGreaterThanCurrent(String releasedVersion, String currentVersion) {
        if (releasedVersion != null && currentVersion != null) {
            VersionStringComparator comparator = new VersionStringComparator();
            return comparator.compare(releasedVersion, currentVersion) > 0;
        }
        return false;
    }

    protected static String runCheck(InputStream xml, String currentVersion) {
        try {
            Node root = XPathUtil.getRootNode(xml);
            String osName = "";
            if (root != null) {
                if (Platform.isWindows()) {
                    osName = "windows";
                } else if (Platform.isLinux()) {
                    osName = "linux";
                } else if (Platform.isMac()) {
                    osName = "osx";
                } else {
                    return null;
                }
                String releasedVersion = XPathUtil.getNodeValue(root, "/serviio_releases/release[@os='" + osName + "']/@version");
                if (UpdateChecker.versionGreaterThanCurrent(releasedVersion, currentVersion)) {
                    return releasedVersion;
                }
            }
        }
        catch (XPathExpressionException e) {
            log.error("Cannot check for latest released version because the XML is corrupted.");
        }
        return null;
    }

    private static class VersionStringComparator
    implements Comparator<String> {
        private VersionStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            String[] arr1 = s1.split("[^a-zA-Z0-9]+");
            String[] arr2 = s2.split("[^a-zA-Z0-9]+");
            int max = Math.min(arr1.length, arr2.length);
            for (int ii = 0; ii <= max; ++ii) {
                int i2;
                int i1;
                if (ii == arr1.length) {
                    return ii == arr2.length ? 0 : -1;
                }
                if (ii == arr2.length) {
                    return 1;
                }
                try {
                    i1 = Integer.parseInt(arr1[ii]);
                }
                catch (Exception x) {
                    i1 = Integer.MAX_VALUE;
                }
                try {
                    i2 = Integer.parseInt(arr2[ii]);
                }
                catch (Exception x) {
                    i2 = Integer.MAX_VALUE;
                }
                if (i1 != i2) {
                    return i1 - i2;
                }
                int i3 = arr1[ii].compareTo(arr2[ii]);
                if (i3 == 0) continue;
                return i3;
            }
            return 0;
        }
    }
}

