/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.update;

import java.io.IOException;
import java.util.ArrayList;
import org.serviio.config.Configuration;
import org.serviio.db.dao.DAOFactory;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.upnp.Device;
import org.serviio.util.JdbcUtils;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSchemaUpdateExecutor {
    private static final Logger log = LoggerFactory.getLogger(DBSchemaUpdateExecutor.class);
    private static final String[] scripts = new String[]{"script-0.1.sql", "script-0.1.1.sql", "script-0.2.sql", "script-0.3.1.sql", "script-0.4.sql", "script-0.4.1.sql", "script-0.4.2.sql", "script-0.5.sql", "script-0.5.1.sql", "script-0.6.sql", "script-0.6.1.sql", "script-0.6.2.sql", "script-1.0.sql", "script-1.1.sql", "script-1.2.sql", "script-1.2.1.sql", "script-1.3.sql", "script-1.4.sql"};

    public static void updateDBSchema() {
        log.info("Checking if DB schema needs to be updated");
        ArrayList<String> scriptsToRun = new ArrayList<String>();
        for (String scriptFile : scripts) {
            boolean scriptRun = false;
            try {
                scriptRun = DAOFactory.getDBLogDAO().isScriptPresent(scriptFile);
            }
            catch (PersistenceException e) {
                log.debug("Error reading db log table, probably doesn't exist yet. Will execute the script.");
            }
            if (scriptRun) continue;
            scriptsToRun.add(scriptFile);
        }
        if (scriptsToRun.size() > 0) {
            log.info("Updating DB schema");
            for (String scriptFile : scriptsToRun) {
                try {
                    String sql = StringUtils.readStreamAsString(DBSchemaUpdateExecutor.class.getResourceAsStream("/sql/" + scriptFile), "UTF-8");
                    JdbcUtils.executeBatchStatement(sql);
                }
                catch (IOException e) {
                    log.error(String.format("Cannot read script file %s", scriptFile));
                }
            }
            log.info("Cleaning temporary cache");
            Device.getInstance().getCDS().incrementUpdateID();
            log.info("Cleaning persistent cache");
            OnlineLibraryManager.getInstance().removePersistentCaches();
            log.debug("Setting a new database update ID");
            Configuration.setDatabaseUpdateId(StringUtils.generateRandomToken());
        }
    }
}

