/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.MediaServer;
import org.serviio.UPnPServerStatus;
import org.serviio.config.Configuration;
import org.serviio.library.entities.AccessGroup;
import org.serviio.licensing.LicensingManager;
import org.serviio.renderer.ActiveRenderer;
import org.serviio.renderer.RendererManager;
import org.serviio.renderer.entities.Renderer;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.restlet.ValidationException;
import org.serviio.ui.representation.RendererRepresentation;
import org.serviio.ui.representation.StatusRepresentation;
import org.serviio.ui.resources.StatusResource;
import org.serviio.util.ObjectValidator;
import org.serviio.util.ThreadUtils;

public class StatusServerResource
extends AbstractServerResource
implements StatusResource {
    static final Pattern ipAddressPattern = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");

    @Override
    public StatusRepresentation load() {
        StatusRepresentation rep = new StatusRepresentation();
        rep.setBoundNICName(Configuration.getBoundNICName());
        rep.setServerStatus(MediaServer.getStatus());
        rep.setRendererEnabledByDefault(Configuration.isRendererEnabledByDefault());
        rep.setDefaultAccessGroupId(Configuration.getRendererDefaultAccessGroupId());
        this.initRenderers(rep);
        return rep;
    }

    @Override
    public ResultRepresentation save(StatusRepresentation rep) {
        boolean restartRequired = false;
        boolean cacheCleanupRequired = false;
        if (this.updateRenderers(rep)) {
            restartRequired = true;
            cacheCleanupRequired = true;
        }
        if (this.updateBoundIPAddress(rep)) {
            restartRequired = true;
        }
        Configuration.setRendererEnabledByDefault(rep.isRendererEnabledByDefault());
        if (rep.getDefaultAccessGroupId() != null) {
            Configuration.setRendererDefaultAccessGroupId(this.getAccessGroupId(rep.getDefaultAccessGroupId()));
        }
        if (restartRequired && MediaServer.getStatus() != UPnPServerStatus.STOPPED) {
            ThreadUtils.runAsynchronously(new Runnable(){

                @Override
                public void run() {
                    MediaServer.stopServer();
                    MediaServer.startServer();
                }
            });
        }
        if (cacheCleanupRequired) {
            this.getCDS().incrementUpdateID();
        }
        return this.responseOk();
    }

    private boolean updateBoundIPAddress(StatusRepresentation rep) {
        boolean addressUpdated = false;
        String originalNICName = Configuration.getBoundNICName();
        String newNICName = rep.getBoundNICName();
        if (originalNICName == null && newNICName != null || originalNICName != null && !originalNICName.equals(newNICName)) {
            addressUpdated = true;
        }
        this.log.debug("Storing bound NIC: " + newNICName);
        Configuration.setBoundNICName(newNICName);
        return addressUpdated;
    }

    private boolean validateIPAddress(String ipAddress) {
        if (ObjectValidator.isNotEmpty(ipAddress)) {
            Matcher m = ipAddressPattern.matcher(ipAddress);
            return m.matches();
        }
        return false;
    }

    private void initRenderers(StatusRepresentation rep) {
        ArrayList<RendererRepresentation> renderers = new ArrayList<RendererRepresentation>();
        List<Renderer> storedRenderers = RendererManager.getInstance().getStoredRenderers();
        Map<String, ActiveRenderer> activeRenderers = RendererManager.getInstance().getActiveRenderers();
        HashSet<Renderer> mergedRenderers = new HashSet<Renderer>();
        mergedRenderers.addAll(storedRenderers);
        for (ActiveRenderer ar : activeRenderers.values()) {
            mergedRenderers.add(ar.getRenderer());
        }
        for (Renderer renderer : mergedRenderers) {
            RendererRepresentation rr = new RendererRepresentation();
            rr.setUuid(renderer.getUuid());
            rr.setIpAddress(renderer.getIpAddress());
            rr.setName(renderer.getName());
            rr.setProfileId(renderer.getProfileId());
            rr.setEnabled(renderer.isEnabled());
            rr.setAccessGroupId(this.getAccessGroupId(renderer.getAccessGroupId()));
            if (activeRenderers.containsKey(renderer.getUuid())) {
                rr.setStatus(RendererRepresentation.RendererStatus.ACTIVE);
            } else if (renderer.isManuallyAdded()) {
                rr.setStatus(RendererRepresentation.RendererStatus.UNKNOWN);
            } else {
                rr.setStatus(RendererRepresentation.RendererStatus.INACTIVE);
            }
            renderers.add(rr);
        }
        Collections.sort(renderers);
        rep.setRenderers(renderers);
    }

    private Long getAccessGroupId(Long providedAccessGroupId) {
        return LicensingManager.getInstance().isProVersion() ? providedAccessGroupId : AccessGroup.NO_LIMIT_ACCESS_GROUP_ID;
    }

    private boolean updateRenderers(StatusRepresentation rep) {
        boolean restartRequired = false;
        this.validateRenderers(rep);
        List<Renderer> storedRenderers = RendererManager.getInstance().getStoredRenderers();
        for (Renderer existingRenderer : storedRenderers) {
            if (this.findRendererRepresentationByUuid(rep.getRenderers(), existingRenderer.getUuid()) != null) continue;
            RendererManager.getInstance().removeRenderer(existingRenderer.getUuid());
        }
        for (RendererRepresentation rr : rep.getRenderers()) {
            Renderer storedRenderer = RendererManager.getInstance().getStoredRendererByUuid(rr.getUuid());
            if (storedRenderer != null) {
                boolean profileUpdated = false;
                if (!storedRenderer.getProfileId().equalsIgnoreCase(rr.getProfileId())) {
                    storedRenderer.setProfileId(rr.getProfileId());
                    storedRenderer.setForcedProfile(true);
                    profileUpdated = true;
                }
                if (storedRenderer.isEnabled() != rr.isEnabled()) {
                    storedRenderer.setEnabled(rr.isEnabled());
                    profileUpdated = true;
                }
                if (ObjectValidator.isNotEmpty(rr.getName()) && !storedRenderer.getName().equalsIgnoreCase(rr.getName())) {
                    storedRenderer.setName(rr.getName());
                    profileUpdated = true;
                }
                if (storedRenderer.getAccessGroupId() != this.getAccessGroupId(rr.getAccessGroupId())) {
                    storedRenderer.setAccessGroupId(this.fixAccessGroupId(rr.getAccessGroupId()));
                    profileUpdated = true;
                }
                if (!profileUpdated) continue;
                restartRequired = true;
                RendererManager.getInstance().updateRenderer(storedRenderer);
                continue;
            }
            this.log.warn("Adding new renderers is not supported. Ignoring the data.");
        }
        return restartRequired;
    }

    private Long fixAccessGroupId(Long accessGroupId) {
        return accessGroupId == null ? Configuration.getRendererDefaultAccessGroupId() : this.getAccessGroupId(accessGroupId);
    }

    private void validateRenderers(StatusRepresentation rep) {
        for (RendererRepresentation rr : rep.getRenderers()) {
            if (this.validateIPAddress(rr.getIpAddress())) continue;
            throw new ValidationException(500);
        }
    }

    public RendererRepresentation findRendererRepresentationByUuid(List<RendererRepresentation> reps, String uuid) {
        for (RendererRepresentation rr : reps) {
            if (!rr.getUuid().equalsIgnoreCase(uuid)) continue;
            return rr;
        }
        return null;
    }
}

