/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.serviio.config.Configuration;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.local.service.RepositoryService;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.library.online.service.OnlineRepositoryService;
import org.serviio.library.service.AccessGroupService;
import org.serviio.licensing.LicensingManager;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.restlet.ValidationException;
import org.serviio.ui.representation.RepositoryRepresentation;
import org.serviio.ui.representation.SharedFolder;
import org.serviio.ui.resources.RepositoryResource;
import org.serviio.util.CollectionUtils;
import org.serviio.util.HttpUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public class RepositoryServerResource
extends AbstractServerResource
implements RepositoryResource {
    @Override
    public RepositoryRepresentation load() {
        RepositoryRepresentation rep = new RepositoryRepresentation();
        this.initSharedFolders(rep);
        this.initOnlineRepositories(rep);
        rep.setSearchHiddenFiles(Configuration.isSearchHiddenFiles());
        rep.setAutomaticLibraryUpdate(Configuration.isAutomaticLibraryRefresh());
        rep.setAutomaticLibraryUpdateInterval(Configuration.getAutomaticLibraryRefreshInterval());
        rep.setSearchForUpdates(Configuration.isSearchUpdatedFiles());
        rep.setMaxNumberOfItemsForOnlineFeeds(Configuration.getMaxNumberOfItemsForOnlineFeeds());
        rep.setOnlineFeedExpiryInterval(Configuration.getOnlineFeedExpiryInterval());
        rep.setOnlineContentPreferredQuality(Configuration.getOnlineFeedPreferredQuality());
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultRepresentation save(RepositoryRepresentation rep) {
        this.saveOnlineRepositories(rep);
        OnlineLibraryManager.getInstance().invokeFeedUpdaterThread();
        if (rep.isSearchHiddenFiles() != null) {
            Configuration.setSearchHiddenFiles(rep.isSearchHiddenFiles());
        }
        if (rep.isSearchForUpdates() != null) {
            Configuration.setSearchUpdatedFiles(rep.isSearchForUpdates());
        }
        if (rep.isAutomaticLibraryUpdate() != null) {
            Configuration.setAutomaticLibraryRefresh(rep.isAutomaticLibraryUpdate());
        }
        if (rep.isAutomaticLibraryUpdate() != null && rep.isAutomaticLibraryUpdate().booleanValue()) {
            Configuration.setAutomaticLibraryRefreshInterval(rep.getAutomaticLibraryUpdateInterval());
        }
        if (rep.getMaxNumberOfItemsForOnlineFeeds() != null) {
            Configuration.setMaxNumberOfItemsForOnlineFeeds(rep.getMaxNumberOfItemsForOnlineFeeds());
        }
        if (rep.getOnlineFeedExpiryInterval() != null) {
            Configuration.setOnlineFeedExpiryInterval(rep.getOnlineFeedExpiryInterval());
        }
        if (rep.getOnlineContentPreferredQuality() != null && rep.getOnlineContentPreferredQuality() != Configuration.getOnlineFeedPreferredQuality()) {
            Configuration.setOnlineFeedPreferredQuality(rep.getOnlineContentPreferredQuality());
            OnlineLibraryManager.getInstance().expireAllFeeds();
        }
        LibraryManager.getInstance().pauseUpdates();
        try {
            this.saveLocalRepositories(rep);
        }
        finally {
            LibraryManager.getInstance().resumeUpdates();
        }
        return this.responseOk();
    }

    private void initSharedFolders(RepositoryRepresentation rep) {
        ArrayList<SharedFolder> repositories = new ArrayList<SharedFolder>();
        List<Repository> allRepositories = RepositoryService.getAllRepositories();
        for (Repository repository : allRepositories) {
            List<AccessGroup> accessGroups = AccessGroupService.getAccessGroupsForRepository(repository.getId());
            SharedFolder repoVO = new SharedFolder(repository.getFolder().getPath(), repository.getSupportedFileTypes(), repository.isSupportsDescriptiveMetadata(), repository.isKeepScanningForUpdates(), new LinkedHashSet<Long>(CollectionUtils.extractEntityIDs(accessGroups)));
            repoVO.setId(repository.getId());
            repositories.add(repoVO);
        }
        rep.setSharedFolders(repositories);
    }

    private void initOnlineRepositories(RepositoryRepresentation rep) {
        ArrayList<org.serviio.ui.representation.OnlineRepository> repositories = new ArrayList<org.serviio.ui.representation.OnlineRepository>();
        List<OnlineRepository> allRepositories = OnlineRepositoryService.getAllRepositories();
        for (OnlineRepository repository : allRepositories) {
            List<AccessGroup> accessGroups = AccessGroupService.getAccessGroupsForOnlineRepository(repository.getId());
            org.serviio.ui.representation.OnlineRepository repoVO = new org.serviio.ui.representation.OnlineRepository(repository.getRepoType(), repository.getRepositoryUrl(), repository.getFileType(), repository.getThumbnailUrl() != null ? repository.getThumbnailUrl().toString() : null, repository.getRepositoryName(), repository.isEnabled(), new LinkedHashSet<Long>(CollectionUtils.extractEntityIDs(accessGroups)));
            repoVO.setId(repository.getId());
            repositories.add(repoVO);
        }
        rep.setOnlineRepositories(repositories);
    }

    private void saveLocalRepositories(RepositoryRepresentation rep) {
        if (rep.getSharedFolders() != null) {
            ArrayList<Repository> reposToSave = new ArrayList<Repository>();
            for (SharedFolder repository : rep.getSharedFolders()) {
                Repository repoToSave = new Repository(new File(repository.getFolderPath()), repository.getSupportedFileTypes(), repository.isDescriptiveMetadataSupported(), repository.isScanForUpdates());
                repoToSave.setId(repository.getId());
                repoToSave.setAccessGroupIds(RepositoryServerResource.fixAccessGroups(repository.getAccessGroupIds()));
                reposToSave.add(repoToSave);
                this.log.debug(String.format("Updating repository with values: %s", repoToSave.toString()));
            }
            boolean mediaItemsModified = RepositoryService.saveRepositories(reposToSave);
            if (mediaItemsModified) {
                this.log.debug("Library updated, notifying CDS");
                this.getCDS().incrementUpdateID();
            }
        }
    }

    public static List<Long> fixAccessGroups(Set<Long> submittedGroups) {
        HashSet<Long> fixedGroupIds = new HashSet<Long>();
        fixedGroupIds.add(AccessGroup.NO_LIMIT_ACCESS_GROUP_ID);
        if (LicensingManager.getInstance().isProVersion() && submittedGroups != null) {
            fixedGroupIds.addAll(submittedGroups);
        }
        return new ArrayList<Long>(fixedGroupIds);
    }

    private void saveOnlineRepositories(RepositoryRepresentation rep) {
        if (rep.getOnlineRepositories() != null) {
            ArrayList<OnlineRepository> reposToSave = new ArrayList<OnlineRepository>();
            for (int i = 0; i < rep.getOnlineRepositories().size(); ++i) {
                org.serviio.ui.representation.OnlineRepository repository = rep.getOnlineRepositories().get(i);
                String contentUrl = this.validateUrl(StringUtils.trim(repository.getContentUrl()), repository.getRepositoryType());
                OnlineRepository repoToSave = new OnlineRepository(repository.getRepositoryType(), contentUrl, repository.getFileType(), repository.getRepositoryName(), i + 1);
                if (repository.getRepositoryType() == OnlineRepository.OnlineRepositoryType.LIVE_STREAM && ObjectValidator.isNotEmpty(repository.getThumbnailUrl())) {
                    repoToSave.setThumbnailUrl(this.validateFeedUrl(StringUtils.trim(repository.getThumbnailUrl())));
                }
                repoToSave.setId(repository.getId());
                repoToSave.setEnabled(repository.isEnabled());
                repoToSave.setAccessGroupIds(RepositoryServerResource.fixAccessGroups(repository.getAccessGroupIds()));
                reposToSave.add(repoToSave);
                this.log.debug(String.format("Updating repository with values: %s", repoToSave.toString()));
            }
            OnlineRepositoryService.saveRepositories(reposToSave);
        }
    }

    protected String validateUrl(String urlString, OnlineRepository.OnlineRepositoryType type) {
        if (type == OnlineRepository.OnlineRepositoryType.FEED || type == OnlineRepository.OnlineRepositoryType.WEB_RESOURCE) {
            return this.validateFeedUrl(urlString).toString();
        }
        String urlToCheck = this.normalizeLiveStreamUrl(urlString);
        try {
            new URI(urlToCheck);
            return urlString;
        }
        catch (URISyntaxException e) {
            this.log.debug(String.format("Invalid URL: %s", urlString));
            throw new ValidationException(503, Collections.singletonList(urlString));
        }
    }

    private String normalizeLiveStreamUrl(String url) {
        if (url.startsWith("rtmp") && url.indexOf(" ") > -1) {
            url = url.substring(0, url.indexOf(" ")).trim();
            url = url.replace("#", "%23");
        } else {
            url = url.replaceAll(" ", "%20");
        }
        return url;
    }

    private URL validateFeedUrl(String urlString) {
        String fixedUrl = this.fixFeedUrl(urlString);
        if (HttpUtils.isHttpUrl(fixedUrl)) {
            try {
                return new URL(fixedUrl);
            }
            catch (MalformedURLException e) {
                this.log.debug(String.format("Invalid URL: %s", fixedUrl));
                throw new ValidationException(503, Collections.singletonList(fixedUrl));
            }
        }
        this.log.debug(String.format("Invalid URL of a feed: %s", urlString));
        throw new ValidationException(503, Collections.singletonList(urlString));
    }

    protected String fixFeedUrl(String url) {
        if (url != null) {
            return url.replaceFirst("feed://", "http://");
        }
        return url;
    }
}

