/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.serviio.db.dao.DAOFactory;
import org.serviio.i18n.Language;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.video.MetadataLanguages;
import org.serviio.library.online.PreferredQuality;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.ui.representation.ReferenceDataRepresentation;
import org.serviio.ui.resources.ReferenceDataResource;
import org.serviio.upnp.service.contentdirectory.definition.ContainerVisibilityType;
import org.serviio.upnp.service.contentdirectory.definition.i18n.BrowsingCategoriesLanguages;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.NetworkInterfaceComparator;
import org.serviio.util.NicIP;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public class ReferenceDataServerResource
extends AbstractServerResource
implements ReferenceDataResource {
    private String name;

    @Override
    public ReferenceDataRepresentation load() {
        return this.getData();
    }

    protected void doInit() throws ResourceException {
        this.name = (String)this.getRequestAttributes().get("name");
    }

    private ReferenceDataRepresentation getData() {
        if (ObjectValidator.isEmpty(this.name)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        } else {
            if (this.name.equalsIgnoreCase("cpu-cores")) {
                return new ReferenceDataRepresentation("numberOfCPUCores", String.valueOf(this.getNumberOfCPUCores()));
            }
            if (this.name.equalsIgnoreCase("profiles")) {
                return this.getProfiles();
            }
            if (this.name.equalsIgnoreCase("metadataLanguages")) {
                return this.getMetadataLanguages();
            }
            if (this.name.equalsIgnoreCase("browsingCategoriesLanguages")) {
                return this.getBrowsingCategoriesLanguages();
            }
            if (this.name.equalsIgnoreCase("descriptiveMetadataExtractors")) {
                return this.getDescriptionMetadataExtractors();
            }
            if (this.name.equalsIgnoreCase("categoryVisibilityTypes")) {
                return this.getCategoryVisibilityTypes();
            }
            if (this.name.equalsIgnoreCase("onlineRepositoryTypes")) {
                return this.getOnlineRepositoryTypes();
            }
            if (this.name.equalsIgnoreCase("onlineContentQualities")) {
                return this.getOnlineContentQualities();
            }
            if (this.name.equalsIgnoreCase("accessGroups")) {
                return this.getAccessGroups();
            }
            if (this.name.equalsIgnoreCase("remoteDeliveryQualities")) {
                return this.getRemoteDeliveryQualities();
            }
            if (this.name.equalsIgnoreCase("networkInterfaces")) {
                return this.getNetworkInterfaces();
            }
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return null;
    }

    private int getNumberOfCPUCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    private ReferenceDataRepresentation getProfiles() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        List<Profile> allProfiles = ProfileManager.getAllSelectableProfiles();
        Collections.sort(allProfiles);
        for (Profile pd : allProfiles) {
            rep.addValue(pd.getId(), pd.getName());
        }
        return rep;
    }

    private ReferenceDataRepresentation getMetadataLanguages() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        for (Language l : MetadataLanguages.getLanguages()) {
            rep.addValue(l.getCode(), l.getName());
        }
        return rep;
    }

    private ReferenceDataRepresentation getBrowsingCategoriesLanguages() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        for (Language l : BrowsingCategoriesLanguages.getLanguages()) {
            rep.addValue(l.getCode(), l.getName());
        }
        return rep;
    }

    private ReferenceDataRepresentation getDescriptionMetadataExtractors() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        rep.addValue("NONE", "No descriptive metadata");
        rep.addValue(ExtractorType.ONLINE_VIDEO_SOURCES.toString(), "Online metadata sources");
        rep.addValue(ExtractorType.SWISSCENTER.toString(), "Swisscenter");
        rep.addValue(ExtractorType.XBMC.toString(), "XBMC .nfo files");
        rep.addValue(ExtractorType.MYMOVIES.toString(), "MyMovies");
        return rep;
    }

    private ReferenceDataRepresentation getCategoryVisibilityTypes() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        rep.addValue(ContainerVisibilityType.DISPLAYED.toString(), "Display category");
        rep.addValue(ContainerVisibilityType.CONTENT_DISPLAYED.toString(), "Display content only");
        rep.addValue(ContainerVisibilityType.DISABLED.toString(), "Disabled");
        return rep;
    }

    private ReferenceDataRepresentation getOnlineRepositoryTypes() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        rep.addValue(OnlineRepository.OnlineRepositoryType.FEED.toString(), "RSS/Atom feed");
        rep.addValue(OnlineRepository.OnlineRepositoryType.LIVE_STREAM.toString(), "Live stream");
        rep.addValue(OnlineRepository.OnlineRepositoryType.WEB_RESOURCE.toString(), "Web Resource");
        return rep;
    }

    private ReferenceDataRepresentation getOnlineContentQualities() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        rep.addValue(PreferredQuality.LOW.toString(), "Low");
        rep.addValue(PreferredQuality.MEDIUM.toString(), "Medium");
        rep.addValue(PreferredQuality.HIGH.toString(), "High");
        return rep;
    }

    private ReferenceDataRepresentation getRemoteDeliveryQualities() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        rep.addValue(DeliveryQuality.QualityType.LOW.toString(), "Low");
        rep.addValue(DeliveryQuality.QualityType.MEDIUM.toString(), "Medium");
        rep.addValue(DeliveryQuality.QualityType.ORIGINAL.toString(), "High");
        return rep;
    }

    private ReferenceDataRepresentation getAccessGroups() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        List<AccessGroup> groups = DAOFactory.getAccessGroupDAO().findAll();
        for (AccessGroup group : groups) {
            rep.addValue(group.getId().toString(), group.getName());
        }
        return rep;
    }

    private ReferenceDataRepresentation getNetworkInterfaces() {
        ReferenceDataRepresentation rep = new ReferenceDataRepresentation();
        try {
            ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>(MultiCastUtils.findAllAvailableInterfaces());
            Collections.sort(nics, new NetworkInterfaceComparator());
            for (NetworkInterface nic : nics) {
                List<NicIP> ips = MultiCastUtils.findIPAddresses(nic);
                for (NicIP ip : ips) {
                    if (!ObjectValidator.isNotEmpty(ip.getNicName())) continue;
                    rep.addValue(ip.nameWithIndex(), String.format("%s (%s)", ip.getIp().getHostAddress(), StringUtils.trimWithEllipsis(nic.getDisplayName(), 40)));
                }
            }
        }
        catch (SocketException e) {
            this.log.warn("Could not get list of all available NICs", (Throwable)e);
        }
        return rep;
    }
}

