/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.serviio.config.Configuration;
import org.serviio.i18n.Language;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.ui.representation.BrowsingCategory;
import org.serviio.ui.representation.PresentationRepresentation;
import org.serviio.ui.resources.PresentationResource;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.ContainerVisibilityType;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.upnp.service.contentdirectory.definition.DefinitionNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.i18n.BrowsingCategoriesMessages;

public class PresentationServerResource
extends AbstractServerResource
implements PresentationResource {
    @Override
    public PresentationRepresentation load() {
        PresentationRepresentation rep = new PresentationRepresentation();
        this.initCategories(rep);
        rep.setLanguage(Configuration.getBrowseMenuPreferredLanguage());
        rep.setShowParentCategoryTitle(Configuration.isBrowseMenuShowNameOfParentCategory());
        rep.setNumberOfFilesForDynamicCategories(Configuration.getNumberOfFilesForDynamicCategories());
        rep.setFilterOutSeries(Configuration.isBrowseFilterOutSeries());
        return rep;
    }

    @Override
    public ResultRepresentation save(PresentationRepresentation rep) {
        boolean cdsUpdateNeeded = this.updateCategories(rep);
        if (!Configuration.getBrowseMenuPreferredLanguage().equals(rep.getLanguage())) {
            Configuration.setBrowseMenuPreferredLanguage(rep.getLanguage());
            BrowsingCategoriesMessages.loadLocale(Language.getLocale(Configuration.getBrowseMenuPreferredLanguage()));
            cdsUpdateNeeded = true;
        }
        if (Configuration.isBrowseMenuShowNameOfParentCategory() != rep.isShowParentCategoryTitle()) {
            Configuration.setBrowseMenuShowNameOfParentCategory(rep.isShowParentCategoryTitle());
            cdsUpdateNeeded = true;
        }
        if (Configuration.isBrowseFilterOutSeries() != rep.isFilterOutSeries()) {
            Configuration.setBrowseFilterOutSeries(rep.isFilterOutSeries());
            cdsUpdateNeeded = true;
        }
        if (Configuration.getNumberOfFilesForDynamicCategories() != rep.getNumberOfFilesForDynamicCategories()) {
            Configuration.setNumberOfFilesForDynamicCategories(rep.getNumberOfFilesForDynamicCategories());
            cdsUpdateNeeded = true;
        }
        if (cdsUpdateNeeded) {
            this.getCDS().incrementUpdateID();
        }
        return this.responseOk();
    }

    private void initCategories(PresentationRepresentation rep) {
        List<BrowsingCategory> categories = this.findEditableContainers(Definition.instance().getContainer("0"));
        rep.getCategories().addAll(categories);
    }

    private List<BrowsingCategory> findEditableContainers(ContainerNode parent) {
        Definition def = Definition.instance();
        ArrayList<BrowsingCategory> categories = new ArrayList<BrowsingCategory>();
        for (DefinitionNode node : parent.getChildNodes()) {
            StaticContainerNode container;
            if (!(node instanceof StaticContainerNode) || !(container = (StaticContainerNode)node).isEditable()) continue;
            BrowsingCategory category = new BrowsingCategory(container.getId(), container.getTitle(), def.getContainerVisibility(container.getId(), false));
            categories.add(category);
            category.getSubCategories().addAll(this.findEditableContainers(container));
        }
        return categories;
    }

    private boolean updateCategories(PresentationRepresentation rep) {
        if (rep.getCategories() != null) {
            this.log.debug("Updating browsing categories' configuration");
            LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
            for (BrowsingCategory category : rep.getCategories()) {
                this.addCategoryToConfig(category, config);
            }
            Configuration.setBrowseMenuItemOptions(config);
            return true;
        }
        return false;
    }

    private void addCategoryToConfig(BrowsingCategory category, Map<String, String> config) {
        if (category.getVisibility() != ContainerVisibilityType.DISPLAYED) {
            config.put(category.getId(), category.getVisibility().toString());
        }
        if (category.getSubCategories() != null) {
            for (BrowsingCategory subCategory : category.getSubCategories()) {
                this.addCategoryToConfig(subCategory, config);
            }
        }
    }
}

