/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.online.service.OnlineRepositoryService;
import org.serviio.library.service.AccessGroupService;
import org.serviio.restlet.AbstractRestfulException;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.ValidationException;
import org.serviio.ui.representation.OnlineRepositoriesBackupRepresentation;
import org.serviio.ui.representation.OnlineRepositoryBackup;
import org.serviio.ui.resources.OnlineRepositoriesImportExportResource;
import org.serviio.ui.resources.server.RepositoryServerResource;
import org.serviio.util.CollectionUtils;
import org.serviio.util.ServiioUri;

public class OnlineRepositoriesImportExportServerResource
extends AbstractServerResource
implements OnlineRepositoriesImportExportResource {
    @Override
    protected Representation doConditionalHandle() {
        try {
            return super.doConditionalHandle();
        }
        catch (AbstractRestfulException e) {
            throw e;
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof AbstractRestfulException) {
                throw (AbstractRestfulException)e.getCause();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.getMethod() == Method.PUT) {
                throw new ValidationException(e.getMessage(), e, 505);
            }
            throw e;
        }
    }

    @Override
    public OnlineRepositoriesBackupRepresentation exportOnlineRepos() {
        this.log.info("Exporting online repositories");
        OnlineRepositoriesBackupRepresentation rep = new OnlineRepositoriesBackupRepresentation();
        List<OnlineRepository> allRepositories = OnlineRepositoryService.getAllRepositories();
        for (OnlineRepository repository : allRepositories) {
            List<AccessGroup> accessGroups = AccessGroupService.getAccessGroupsForOnlineRepository(repository.getId());
            OnlineRepositoryBackup backup = new OnlineRepositoryBackup(repository.toServiioUri(), repository.isEnabled(), repository.getOrder(), new LinkedHashSet<Long>(CollectionUtils.extractEntityIDs(accessGroups)));
            rep.getItems().add(backup);
        }
        return rep;
    }

    @Override
    public void importOnlineRepos(OnlineRepositoriesBackupRepresentation backup) {
        this.log.info("Importing online repositories");
        List<OnlineRepository> currentRepositories = OnlineRepositoryService.getAllRepositories();
        List<OnlineRepositoryBackup> backedUpRepos = backup.getItems();
        Collections.sort(backedUpRepos);
        boolean importedSomething = false;
        for (int i = 0; i < backedUpRepos.size(); ++i) {
            OnlineRepositoryBackup backedUpRepo = backedUpRepos.get(i);
            try {
                ServiioUri serviioUri = ServiioUri.get(backedUpRepo.getServiioLink());
                if (serviioUri == null) continue;
                OnlineRepository existingRepo = this.findRepositoryByUri(currentRepositories, serviioUri);
                if (existingRepo == null) {
                    OnlineRepository importedRepo = new OnlineRepository(serviioUri.getRepoType(), serviioUri.getRepositoryUrl(), serviioUri.getFileType(), serviioUri.getRepositoryName(), currentRepositories.size() + 1);
                    importedRepo.setEnabled(backedUpRepo.isEnabled());
                    importedRepo.setThumbnailUrl(this.validateUrl(serviioUri.getThumbnailUrl()));
                    importedRepo.setAccessGroupIds(RepositoryServerResource.fixAccessGroups(backedUpRepo.getAccessGroupIds()));
                    currentRepositories.add(importedRepo);
                    importedSomething = true;
                    continue;
                }
                if (existingRepo.isEnabled() == backedUpRepo.isEnabled()) continue;
                existingRepo.setEnabled(backedUpRepo.isEnabled());
                importedSomething = true;
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Failed to parse ServiioLink, interrupting import", (Throwable)e);
                throw new ValidationException(e.getMessage(), (Throwable)e, 503, Collections.singletonList(backedUpRepo.getServiioLink()));
            }
        }
        if (importedSomething) {
            OnlineRepositoryService.saveRepositories(currentRepositories);
        }
        this.responseOk();
    }

    private OnlineRepository findRepositoryByUri(List<OnlineRepository> currentRepositories, ServiioUri serviioUri) {
        for (OnlineRepository ol : currentRepositories) {
            if (!ol.getFileType().equals((Object)serviioUri.getFileType()) || !ol.getRepositoryUrl().equalsIgnoreCase(serviioUri.getRepositoryUrl())) continue;
            return ol;
        }
        return null;
    }
}

