/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.util.ArrayList;
import java.util.List;
import org.serviio.config.Configuration;
import org.serviio.library.entities.MetadataExtractorConfig;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.MetadataExtractorFactory;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.ui.representation.MetadataRepresentation;
import org.serviio.ui.resources.MetadataResource;
import org.serviio.util.ServiioThreadFactory;

public class MetadataServerResource
extends AbstractServerResource
implements MetadataResource {
    private static final String DESCRIPTIVE_METADATA_EXTRACTOR_NONE = "NONE";

    @Override
    public MetadataRepresentation load() {
        MetadataRepresentation rep = new MetadataRepresentation();
        this.initAudioExtractors(rep);
        this.initVideoExtractors(rep);
        rep.setVideoOnlineArtExtractorEnabled(Configuration.isRetrieveArtFromOnlineSources());
        rep.setVideoGenerateLocalThumbnailEnabled(Configuration.isGenerateLocalThumbnailForVideos());
        rep.setImageGenerateLocalThumbnailEnabled(Configuration.isGenerateLocalThumbnailForImages());
        rep.setMetadataLanguage(Configuration.getMetadataPreferredLanguage());
        rep.setRetrieveOriginalTitle(Configuration.isMetadataUseOriginalTitle());
        return rep;
    }

    @Override
    public ResultRepresentation save(MetadataRepresentation representation) {
        List<ExtractorType> newVideoExtractors = this.createNewVideoExtractors(representation);
        boolean audioExtractorsUpdated = MediaService.updateMetadataExtractorConfigs(this.createNewAudioExtractors(representation), MediaFileType.AUDIO);
        boolean videoExtractorsUpdated = MediaService.updateMetadataExtractorConfigs(newVideoExtractors, MediaFileType.VIDEO);
        boolean imageExtractorsUpdated = false;
        if (newVideoExtractors.contains((Object)ExtractorType.ONLINE_VIDEO_SOURCES) && Configuration.isRetrieveArtFromOnlineSources() != representation.isVideoOnlineArtExtractorEnabled()) {
            Configuration.setRetrieveArtFromOnlineSources(representation.isVideoOnlineArtExtractorEnabled());
            videoExtractorsUpdated = true;
        }
        if (Configuration.isGenerateLocalThumbnailForVideos() != representation.isVideoGenerateLocalThumbnailEnabled()) {
            Configuration.setGenerateLocalThumbnailForVideos(representation.isVideoGenerateLocalThumbnailEnabled());
            videoExtractorsUpdated = true;
        }
        if (Configuration.isGenerateLocalThumbnailForImages() != representation.isImageGenerateLocalThumbnailEnabled()) {
            Configuration.setGenerateLocalThumbnailForImages(representation.isImageGenerateLocalThumbnailEnabled());
            imageExtractorsUpdated = true;
        }
        Configuration.setMetadataPreferredLanguage(representation.getMetadataLanguage());
        Configuration.setMetadataUseOriginalTitle(representation.isRetrieveOriginalTitle());
        if (audioExtractorsUpdated || videoExtractorsUpdated || imageExtractorsUpdated) {
            final boolean vu = videoExtractorsUpdated;
            final boolean au = audioExtractorsUpdated;
            final boolean iu = imageExtractorsUpdated;
            ServiioThreadFactory.getInstance().newThread(new Runnable(){

                @Override
                public void run() {
                    MetadataExtractorFactory.getInstance().configure();
                    LibraryManager.getInstance().pauseUpdates();
                    if (au) {
                        MediaService.markMediaItemsAsDirty(MediaFileType.AUDIO);
                    }
                    if (vu) {
                        MediaService.markMediaItemsAsDirty(MediaFileType.VIDEO);
                    }
                    if (iu) {
                        MediaService.markMediaItemsAsDirty(MediaFileType.IMAGE);
                    }
                    LibraryManager.getInstance().resumeUpdates();
                }
            }).start();
        }
        return this.responseOk();
    }

    private void initAudioExtractors(MetadataRepresentation representation) {
        List<MetadataExtractorConfig> configs = MediaService.getMetadataExtractorConfigs(MediaFileType.AUDIO);
        for (MetadataExtractorConfig config : configs) {
            if (config.getExtractorType() != ExtractorType.COVER_IMAGE_IN_FOLDER) continue;
            representation.setAudioLocalArtExtractorEnabled(true);
        }
    }

    private void initVideoExtractors(MetadataRepresentation representation) {
        List<MetadataExtractorConfig> configs = MediaService.getMetadataExtractorConfigs(MediaFileType.VIDEO);
        boolean descriptiveMetadataExtractorSelected = false;
        for (MetadataExtractorConfig config : configs) {
            if (config.getExtractorType() == ExtractorType.COVER_IMAGE_IN_FOLDER) {
                representation.setVideoLocalArtExtractorEnabled(true);
                continue;
            }
            if (!config.getExtractorType().isDescriptiveMetadataExtractor()) continue;
            representation.setDescriptiveMetadataExtractor(config.getExtractorType().toString());
            descriptiveMetadataExtractorSelected = true;
        }
        if (!descriptiveMetadataExtractorSelected) {
            representation.setDescriptiveMetadataExtractor(DESCRIPTIVE_METADATA_EXTRACTOR_NONE);
        }
    }

    private List<ExtractorType> createNewAudioExtractors(MetadataRepresentation rep) {
        ArrayList<ExtractorType> configs = new ArrayList<ExtractorType>();
        if (rep.isAudioLocalArtExtractorEnabled()) {
            configs.add(ExtractorType.COVER_IMAGE_IN_FOLDER);
        }
        return configs;
    }

    private List<ExtractorType> createNewVideoExtractors(MetadataRepresentation rep) {
        String descriptiveMDExtractor;
        ArrayList<ExtractorType> configs = new ArrayList<ExtractorType>();
        if (rep.isVideoLocalArtExtractorEnabled()) {
            configs.add(ExtractorType.COVER_IMAGE_IN_FOLDER);
        }
        if (!(descriptiveMDExtractor = rep.getDescriptiveMetadataExtractor()).equals(DESCRIPTIVE_METADATA_EXTRACTOR_NONE)) {
            try {
                ExtractorType et = ExtractorType.valueOf(descriptiveMDExtractor);
                configs.add(et);
            }
            catch (Exception e) {
                this.log.warn(String.format("Unrecognised extractor type '%s', using NONE", descriptiveMDExtractor));
            }
        }
        return configs;
    }
}

