/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.io.IOException;
import org.restlet.representation.InputRepresentation;
import org.serviio.config.Configuration;
import org.serviio.licensing.InvalidLicenseException;
import org.serviio.licensing.LicensingManager;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.restlet.ValidationException;
import org.serviio.ui.resources.LicenseUploadResource;
import org.serviio.util.FileUtils;

public class LicenseUploadServerResource
extends AbstractServerResource
implements LicenseUploadResource {
    @Override
    public ResultRepresentation save(InputRepresentation rep) throws IOException {
        byte[] receivedBytes = FileUtils.readFileBytes(rep.getStream());
        String postedLicense = new String(receivedBytes, "UTF-8");
        try {
            this.log.debug("Validating uploaded license");
            LicensingManager.getInstance().validateLicense(postedLicense);
            Configuration.setCustomerLicense(postedLicense);
            this.log.info("New license stored");
            LicensingManager.getInstance().updateLicense();
        }
        catch (InvalidLicenseException e) {
            this.log.warn("License is not stored because it's not valid: " + e.getMessage(), (Throwable)e);
            throw new ValidationException(e.getMessage(), 555);
        }
        return this.responseOk();
    }
}

