/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import org.serviio.MediaServer;
import org.serviio.config.Configuration;
import org.serviio.licensing.LicensingManager;
import org.serviio.licensing.ServiioLicense;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.ui.representation.ApplicationRepresentation;
import org.serviio.ui.representation.LicenseRepresentation;
import org.serviio.ui.resources.ApplicationResource;
import org.serviio.update.UpdateChecker;

public class ApplicationServerResource
extends AbstractServerResource
implements ApplicationResource {
    @Override
    public ApplicationRepresentation load() {
        ApplicationRepresentation rep = new ApplicationRepresentation();
        rep.setUpdateVersionAvailable(UpdateChecker.getNewAvailableVersion());
        rep.setVersion(MediaServer.VERSION);
        rep.setDatabaseUpdateId(Configuration.getDatabaseUpdateId().toString());
        ServiioLicense lic = LicensingManager.getInstance().getLicense();
        rep.setEdition(lic.getEdition());
        if (lic.getEdition() != LicensingManager.ServiioEdition.FREE) {
            rep.setLicense(this.buildLicense(lic));
        }
        return rep;
    }

    private LicenseRepresentation buildLicense(ServiioLicense lic) {
        LicenseRepresentation rep = new LicenseRepresentation();
        if (this.includePersonalDetails()) {
            rep.setEmail(lic.isBundled() ? null : lic.getEmail());
        }
        rep.setExpiresInMinutes(this.getExpiresInMinutes(lic.getRemainingMillis()));
        rep.setId(lic.isBundled() ? null : lic.getId());
        if (this.includePersonalDetails()) {
            rep.setName(lic.isBundled() ? null : lic.getName());
        }
        rep.setType(lic.getType());
        return rep;
    }

    protected boolean includePersonalDetails() {
        return true;
    }

    private Integer getExpiresInMinutes(Long milliseconds) {
        return milliseconds != null ? Integer.valueOf(new Long(milliseconds / 60000L).intValue()) : null;
    }
}

