/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.ui.resources.server;

import java.io.IOException;
import org.restlet.data.Status;
import org.serviio.MediaServer;
import org.serviio.config.Configuration;
import org.serviio.delivery.DeliveryContext;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.MetadataFactory;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.metadata.FFmpegMetadataRetriever;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.library.online.service.OnlineRepositoryService;
import org.serviio.restlet.AbstractServerResource;
import org.serviio.restlet.OperationException;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.restlet.ValidationException;
import org.serviio.ui.representation.ActionRepresentation;
import org.serviio.ui.resources.ActionsResource;
import org.serviio.upnp.discovery.DiscoveryManager;
import org.serviio.upnp.service.contentdirectory.rest.access.PortMappingChecker;
import org.serviio.util.StringUtils;

public class ActionsServerResource
extends AbstractServerResource
implements ActionsResource {
    @Override
    public ResultRepresentation execute(ActionRepresentation representation) {
        if (representation == null) {
            this.log.error("No action name specified, returning 400");
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        } else {
            this.log.debug(String.format("Action with name '%s' was requested", representation.getName()));
            if (representation.getName().equals("forceVideoFilesMetadataUpdate")) {
                return this.forceOnlineVideoFilesUpdate(representation);
            }
            if (representation.getName().equals("forceLibraryRefresh")) {
                return this.forceLibraryRefresh(representation);
            }
            if (representation.getName().equals("forceOnlineResourceRefresh")) {
                return this.forceOnlineResourceRefresh(representation);
            }
            if (representation.getName().equals("startServer")) {
                return this.startServer(representation);
            }
            if (representation.getName().equals("stopServer")) {
                return this.stopServer(representation);
            }
            if (representation.getName().equals("exitServiio")) {
                return this.exitServiio(representation);
            }
            if (representation.getName().equals("advertiseService")) {
                return this.advertiseService(representation);
            }
            if (representation.getName().equals("checkStreamUrl")) {
                return this.checkStreamUrl(representation);
            }
            if (representation.getName().equals("checkPortMapping")) {
                return this.checkPortMapping(representation);
            }
            this.log.error(String.format("Action with name '%s' is not implemented, returning 400", representation.getName()));
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return null;
    }

    private ResultRepresentation forceOnlineVideoFilesUpdate(ActionRepresentation representation) {
        LibraryManager.getInstance().forceMetadataUpdate(MediaFileType.VIDEO);
        return this.responseOk();
    }

    private synchronized ResultRepresentation forceLibraryRefresh(ActionRepresentation representation) {
        LibraryManager.getInstance().stopLibraryAdditionsCheckerThread();
        LibraryManager.getInstance().stopLibraryUpdatesCheckerThread();
        LibraryManager.getInstance().startLibraryAdditionsCheckerThread();
        LibraryManager.getInstance().startLibraryUpdatesCheckerThread();
        return this.responseOk();
    }

    private synchronized ResultRepresentation forceOnlineResourceRefresh(ActionRepresentation representation) {
        this.validateParameters(representation, 1);
        OnlineRepository rep = OnlineRepositoryService.getRepository(Long.parseLong(representation.getParameters().get(0)));
        OnlineLibraryManager.getInstance().removeOnlineContentFromCache(rep.getRepositoryUrl(), rep.getId(), true);
        return this.responseOk();
    }

    private ResultRepresentation startServer(ActionRepresentation representation) {
        MediaServer.startServer();
        return this.responseOk();
    }

    private ResultRepresentation stopServer(ActionRepresentation representation) {
        MediaServer.stopServer();
        return this.responseOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultRepresentation exitServiio(ActionRepresentation representation) {
        try {
            ResultRepresentation resultRepresentation = this.responseOk();
            return resultRepresentation;
        }
        finally {
            MediaServer.exit();
        }
    }

    private ResultRepresentation advertiseService(ActionRepresentation representation) {
        try {
            DiscoveryManager.instance().sendSSDPAlive();
            return this.responseOk();
        }
        catch (IOException e) {
            throw new OperationException(e, 602);
        }
    }

    private ResultRepresentation checkStreamUrl(ActionRepresentation representation) {
        this.validateParameters(representation, 2);
        try {
            MediaFileType fileType = MediaFileType.valueOf(representation.getParameters().get(0));
            String url = StringUtils.trim(representation.getParameters().get(1));
            LocalItemMetadata md = MetadataFactory.getMetadataInstance(fileType);
            FFmpegMetadataRetriever.retrieveOnlineMetadata(md, url, new DeliveryContext(false, null));
            return this.responseOk();
        }
        catch (InvalidMediaFormatException e) {
            return this.responseOk(603);
        }
        catch (IOException e) {
            return this.responseOk(603);
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage(), 700);
        }
    }

    private ResultRepresentation checkPortMapping(ActionRepresentation representation) {
        try {
            boolean open = PortMappingChecker.isPortOpen(Configuration.getRemoteExternalAddress(), 23424);
            if (open) {
                return this.responseOk();
            }
            return this.responseOk(604);
        }
        catch (IOException e) {
            return this.responseOk(605);
        }
    }

    private void validateParameters(ActionRepresentation representation, int paramNumber) throws ValidationException {
        if (representation.getParameters() == null || representation.getParameters().size() != paramNumber) {
            throw new ValidationException(700);
        }
    }
}

