/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.restlet;

import java.io.FileNotFoundException;
import java.util.List;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.ext.gson.GsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.service.StatusService;
import org.serviio.restlet.AbstractRestfulException;
import org.serviio.restlet.AuthenticationException;
import org.serviio.restlet.HttpCodeException;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.restlet.ServerUnavailableException;
import org.serviio.restlet.ServiioXstreamRepresentation;
import org.serviio.restlet.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiioStatusService
extends StatusService {
    private static final Logger log = LoggerFactory.getLogger(ServiioStatusService.class);

    public Representation getRepresentation(Status status, Request request, Response response) {
        if (status.getThrowable() != null) {
            log.warn(String.format("%s occured. Returning error code %s to the REST layer. Message: %s", status.getThrowable().getClass().getSimpleName(), status.getCode(), status.getThrowable().getMessage()));
            log.debug("Detailed exception: ", status.getThrowable());
        } else {
            log.warn(String.format("Returning error code to the REST layer: %s", status.toString()));
        }
        response.setStatus(status);
        if (status.getThrowable() != null && status.getThrowable() instanceof AbstractRestfulException) {
            int errorCode = ((AbstractRestfulException)status.getThrowable()).getErrorCode();
            List<String> parameters = ((AbstractRestfulException)status.getThrowable()).getParameters();
            ResultRepresentation r = this.responseError(errorCode, parameters);
            return this.buildResultRepresentation(request, r);
        }
        ResultRepresentation r = this.responseError(null, null);
        return this.buildResultRepresentation(request, r);
    }

    public Status getStatus(Throwable throwable, Request request, Response response) {
        if (throwable instanceof ResourceException) {
            ResourceException re = (ResourceException)throwable;
            return re.getStatus();
        }
        if (throwable instanceof ValidationException) {
            return new Status(Status.CLIENT_ERROR_BAD_REQUEST, throwable);
        }
        if (throwable instanceof HttpCodeException) {
            return new Status(((HttpCodeException)throwable).getHttpCode(), throwable);
        }
        if (throwable instanceof AuthenticationException) {
            return new Status(Status.CLIENT_ERROR_UNAUTHORIZED, throwable);
        }
        if (throwable instanceof FileNotFoundException) {
            return new Status(Status.CLIENT_ERROR_NOT_FOUND, throwable);
        }
        if (throwable instanceof ServerUnavailableException) {
            return new Status(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, throwable);
        }
        return new Status(Status.SERVER_ERROR_INTERNAL, throwable);
    }

    private ResultRepresentation responseError(Integer errorCode, List<String> parameters) {
        return new ResultRepresentation(errorCode, parameters);
    }

    private Representation buildResultRepresentation(Request request, ResultRepresentation r) {
        MediaType mt = null;
        List acceptedMediaTypes = request.getClientInfo().getAcceptedMediaTypes();
        if (acceptedMediaTypes != null && acceptedMediaTypes.size() > 0) {
            mt = (MediaType)((Preference)acceptedMediaTypes.get(0)).getMetadata();
        }
        if (mt != null && mt.getName().startsWith(MediaType.APPLICATION_JSON.getName())) {
            return new GsonRepresentation((Object)r);
        }
        return new ServiioXstreamRepresentation<ResultRepresentation>(mt, r);
    }
}

