/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.restlet;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.ext.gson.GsonConverter;
import org.restlet.service.StatusService;
import org.serviio.restlet.ServiioStatusService;
import org.serviio.restlet.ServiioXstreamConverter;
import org.serviio.ui.ApiRestletApplication;
import org.serviio.upnp.service.contentdirectory.rest.ContentDirectoryRestletApplication;
import org.serviio.upnp.webserver.WebServer;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletServer {
    private static final Logger log = LoggerFactory.getLogger(RestletServer.class);
    private static Component apiComponent = new Component();
    private static Component cdsComponent = new Component();
    private static Component mbComponent = new Component();

    public static void runServer() {
        try {
            List registeredConverters = Engine.getInstance().getRegisteredConverters();
            registeredConverters.add(0, new GsonConverter());
            registeredConverters.add(1, new ServiioXstreamConverter());
            ApiRestletApplication apiApp = new ApiRestletApplication();
            RestletServer.prepareComponent(apiComponent, Collections.singletonMap("/rest", apiApp), 23423);
            apiComponent.start();
            ContentDirectoryRestletApplication cdsApp = new ContentDirectoryRestletApplication();
            Application mbApp = (Application)RestletServer.createInstanceOfApplication("org.serviio.mediabrowser.rest.MediaBrowserRestletApplication");
            HashMap<String, Application> cdsApplications = new HashMap<String, Application>();
            cdsApplications.put("/cds", cdsApp);
            cdsApplications.put("/mediabrowser", mbApp);
            RestletServer.prepareComponent(cdsComponent, cdsApplications, 23424);
            cdsComponent.start();
            mbComponent.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stopServer() {
        try {
            apiComponent.stop();
            cdsComponent.stop();
            mbComponent.stop();
        }
        catch (Exception e) {
            log.warn("Error during shutting down Restlet server", (Throwable)e);
        }
    }

    private static void prepareComponent(Component component, Map<String, Application> applications, int port) {
        Server httpServer = null;
        String remoteHost = System.getProperty("serviio.remoteHost");
        httpServer = ObjectValidator.isNotEmpty(remoteHost) ? new Server(Protocol.HTTP, remoteHost, port) : new Server(Protocol.HTTP, port);
        component.getServers().add(httpServer);
        httpServer.getContext().getParameters().add("outboundBufferSize", Integer.toString(WebServer.getSocketBufferSize()));
        httpServer.getContext().getParameters().add("inboundBufferSize", Integer.toString(WebServer.getSocketBufferSize()));
        httpServer.getContext().getParameters().add("persistingConnections", "false");
        for (Map.Entry<String, Application> application : applications.entrySet()) {
            if (ObjectValidator.isNotEmpty(remoteHost)) {
                log.info(String.format("Starting Restlet server (%s) exposed on %s:%s", application.getKey(), remoteHost, port));
            } else {
                log.info(String.format("Starting Restlet server (%s) exposed on port %s", application.getKey(), port));
            }
            application.getValue().setStatusService((StatusService)new ServiioStatusService());
            application.getValue().getRangeService().setEnabled(false);
            component.getDefaultHost().attach(application.getKey(), (Restlet)application.getValue());
        }
    }

    private static Object createInstanceOfApplication(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

