/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.restlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.ServerResource;
import org.serviio.restlet.ResultRepresentation;
import org.serviio.restlet.ValidationException;
import org.serviio.upnp.Device;
import org.serviio.upnp.protocol.ssdp.SSDPConstants;
import org.serviio.upnp.service.contentdirectory.ContentDirectory;
import org.serviio.util.HttpUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerResource
extends ServerResource {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected ResultRepresentation responseOk() {
        return this.responseOk(0);
    }

    protected ResultRepresentation responseOk(int errorCode) {
        this.setStatus(Status.SUCCESS_OK);
        return new ResultRepresentation(errorCode, null);
    }

    protected ContentDirectory getCDS() {
        return Device.getInstance().getCDS();
    }

    protected Representation doConditionalHandle() {
        Representation rep = super.doConditionalHandle();
        this.getResponse().getServerInfo().setAgent(SSDPConstants.SERVER);
        return rep;
    }

    protected URL validateUrl(String urlString) {
        if (ObjectValidator.isNotEmpty(urlString) && HttpUtils.isHttpUrl(urlString)) {
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException e) {
                this.log.debug(String.format("Invalid URL: %s", urlString));
                throw new ValidationException(503, Collections.singletonList(urlString));
            }
        }
        return null;
    }
}

