/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.renderer.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.renderer.dao.RendererDAO;
import org.serviio.renderer.entities.Renderer;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererDAOImpl
implements RendererDAO {
    private static final Logger log = LoggerFactory.getLogger(RendererDAOImpl.class);

    @Override
    public void create(Renderer newInstance) throws InvalidArgumentException, PersistenceException {
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getUuid())) {
            throw new InvalidArgumentException("Cannot create Renderer. Required data is missing.");
        }
        log.debug(String.format("Creating a new Renderer (uuid = %s)", newInstance.getUuid()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO renderer (uuid, name, ip_address, profile_id, manually_added, profile_forced, enabled, access_group_id) VALUES (?,?,?,?,?,?,?,?)");
            ps.setString(1, newInstance.getUuid());
            JdbcUtils.setStringValueOnStatement(ps, 2, newInstance.getName());
            JdbcUtils.setStringValueOnStatement(ps, 3, newInstance.getIpAddress());
            JdbcUtils.setStringValueOnStatement(ps, 4, newInstance.getProfileId());
            ps.setBoolean(5, newInstance.isManuallyAdded());
            ps.setBoolean(6, newInstance.isForcedProfile());
            ps.setBoolean(7, newInstance.isEnabled());
            JdbcUtils.setLongValueOnStatement(ps, 8, newInstance.getAccessGroupId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Renderer with uuid %s", newInstance.getUuid()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public void delete(String uuid) throws PersistenceException {
        log.debug(String.format("Deleting a Renderer (uuid = %s)", uuid));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM renderer WHERE uuid = ?");
            ps.setString(1, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete Renderer with uuid = %s", uuid), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public Renderer read(String uuid) throws PersistenceException {
        Renderer renderer;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT uuid,name,ip_address,profile_id,manually_added,profile_forced,enabled,access_group_id FROM renderer where lower(uuid) = ?");
            ps.setString(1, StringUtils.localeSafeToLowercase(uuid));
            ResultSet rs = ps.executeQuery();
            renderer = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Renderer with uuid = %s", uuid), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return renderer;
    }

    @Override
    public void update(Renderer transientObject) throws InvalidArgumentException, PersistenceException {
        if (transientObject == null || transientObject.getUuid() == null || transientObject.getIpAddress() == null) {
            throw new InvalidArgumentException("Cannot update Renderer. Required data is missing.");
        }
        log.debug(String.format("Updating Renderer (uuid = %s, ipAddress = %s)", transientObject.getUuid(), transientObject.getIpAddress()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE renderer SET name = ?, ip_address = ?, profile_id = ?, manually_added = ?, profile_forced = ?, enabled = ?, access_group_id = ? WHERE uuid = ?");
            JdbcUtils.setStringValueOnStatement(ps, 1, transientObject.getName());
            JdbcUtils.setStringValueOnStatement(ps, 2, transientObject.getIpAddress());
            JdbcUtils.setStringValueOnStatement(ps, 3, transientObject.getProfileId());
            ps.setBoolean(4, transientObject.isManuallyAdded());
            ps.setBoolean(5, transientObject.isForcedProfile());
            ps.setBoolean(6, transientObject.isEnabled());
            JdbcUtils.setLongValueOnStatement(ps, 7, transientObject.getAccessGroupId());
            ps.setString(8, transientObject.getUuid());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update Renderer with uuid %s", transientObject.getUuid()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<Renderer> findByIPAddress(String ipAddress) throws PersistenceException {
        List<Renderer> list;
        log.debug(String.format("Reading a Renderer with ip address %s", ipAddress));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT uuid,name,ip_address,profile_id,manually_added,profile_forced,enabled,access_group_id FROM renderer where ip_address = ?");
            ps.setString(1, ipAddress);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Renderer with ip address %s", ipAddress), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<Renderer> findAll() throws PersistenceException {
        List<Renderer> list;
        log.debug("Retrieving list of all stored renderers");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT uuid,name,ip_address,profile_id,manually_added,profile_forced,enabled,access_group_id FROM renderer");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of all stored renderers", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    protected Renderer mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initRenderer(rs);
        }
        return null;
    }

    protected List<Renderer> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Renderer> result = new ArrayList<Renderer>();
        while (rs.next()) {
            result.add(this.initRenderer(rs));
        }
        return result;
    }

    private Renderer initRenderer(ResultSet rs) throws SQLException {
        String uuid = rs.getString("uuid");
        String name = rs.getString("name");
        String ipAddress = rs.getString("ip_address");
        String profileId = rs.getString("profile_id");
        boolean manuallyAdded = rs.getBoolean("manually_added");
        boolean forcedprofile = rs.getBoolean("profile_forced");
        boolean enabled = rs.getBoolean("enabled");
        Long accessGroupId = rs.getLong("access_group_id");
        Renderer renderer = new Renderer(uuid, ipAddress, name, profileId, manuallyAdded, forcedprofile, enabled, accessGroupId);
        return renderer;
    }
}

