/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.renderer;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.Header;
import org.serviio.config.Configuration;
import org.serviio.db.dao.DAOFactory;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.renderer.ActiveRenderer;
import org.serviio.renderer.CannotResolveRendererProfileException;
import org.serviio.renderer.RendererExpirationChecker;
import org.serviio.renderer.dao.RendererDAO;
import org.serviio.renderer.entities.Renderer;
import org.serviio.upnp.discovery.RendererSearchSender;
import org.serviio.util.HttpClient;
import org.serviio.util.HttpUtils;
import org.serviio.util.ServiioThreadFactory;
import org.serviio.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class RendererManager {
    private static final String UNKNOWN_DEVICE_NAME = "Unrecognized device";
    private static RendererManager instance;
    private static final Logger log;
    private static final UPnPDeviceNamespaceContext nsContext;
    private Map<String, ActiveRenderer> activeRenderers = Collections.synchronizedMap(new HashMap());
    private RendererExpirationChecker expirationChecker;
    private RendererSearchSender searchSender = new RendererSearchSender(4, 3);
    private RendererDAO rendererDao = DAOFactory.getRendererDAO();

    private RendererManager() {
    }

    public static synchronized RendererManager getInstance() {
        if (instance == null) {
            instance = new RendererManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rendererAvailable(String uuid, String ipAddress, int timeToKeep, String descriptionURL, String server) {
        Map<String, ActiveRenderer> map = this.activeRenderers;
        synchronized (map) {
            boolean addRenderer = false;
            ActiveRenderer activeRenderer = this.activeRenderers.get(uuid);
            Renderer renderer = null;
            if (activeRenderer == null) {
                renderer = this.rendererDao.read(uuid);
                if (renderer != null) {
                    this.updateRendererWithANewIPAddress(renderer, ipAddress);
                } else {
                    try {
                        renderer = this.getProfileByRendererDescriptionFromURL(uuid, ipAddress, server, descriptionURL);
                    }
                    catch (CannotResolveRendererProfileException e) {
                        log.warn(String.format("Error while retrieving renderer description: %s", e.getMessage()));
                        return;
                    }
                }
                addRenderer = true;
            } else {
                renderer = activeRenderer.getRenderer();
                if (this.updateRendererWithANewIPAddress(renderer, ipAddress)) {
                    addRenderer = true;
                }
            }
            if (addRenderer) {
                log.debug(String.format("Adding renderer %s to list of active renderers", renderer));
            }
            activeRenderer = new ActiveRenderer(renderer, timeToKeep, new Date());
            this.activeRenderers.put(uuid, activeRenderer);
        }
    }

    public synchronized void rendererAvailable(Header[] httpHeaders, String ipAddress) {
        try {
            Renderer existingRenderer = this.getStoredRendererByIPAddress(Inet4Address.getByName(ipAddress));
            log.debug(String.format("Looking for a renderer profile for Http headers: %s", HttpUtils.headersToString(httpHeaders)));
            Profile profileByDescription = ProfileManager.findProfileByHeader(httpHeaders);
            Renderer renderer = new Renderer(UUID.randomUUID().toString(), ipAddress, null, null, true, false, Configuration.isRendererEnabledByDefault(), Configuration.getRendererDefaultAccessGroupId());
            if (profileByDescription != null) {
                renderer.setProfileId(profileByDescription.getId());
                renderer.setName(profileByDescription.getName());
            } else {
                renderer.setProfileId("1");
                renderer.setName(UNKNOWN_DEVICE_NAME);
            }
            if (existingRenderer == null) {
                this.createRenderer(renderer);
            } else if (profileByDescription != null && !existingRenderer.isForcedProfile() && !existingRenderer.getProfileId().equalsIgnoreCase(renderer.getProfileId())) {
                log.debug(String.format("Updating renderer on IP %s (forced: %s, profile: %s) with profile %s", ipAddress, existingRenderer.isForcedProfile(), existingRenderer.getProfileId(), renderer.getProfileId()));
                this.removeRendererWithIPAddress(ipAddress);
                this.createRenderer(renderer);
            }
        }
        catch (UnknownHostException e) {
            log.warn("Invalid ip address of renderer, it will not be registered: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rendererUnavailable(String uuid) {
        Map<String, ActiveRenderer> map = this.activeRenderers;
        synchronized (map) {
            if (this.activeRenderers.containsKey(uuid)) {
                log.debug(String.format("Removing renderer %s from list of active renderers", uuid));
                this.activeRenderers.remove(uuid);
            }
        }
    }

    public void searchForActiveRenderers() {
        try {
            this.searchSender.searchForRenderers();
        }
        catch (IOException e) {
            log.warn(String.format("Exception during searching for active renderers: %s", e.getMessage()));
        }
    }

    public Renderer getStoredRendererByIPAddress(InetAddress ipAddress) {
        List<Renderer> renderers = this.rendererDao.findByIPAddress(ipAddress.getHostAddress());
        if (renderers.size() > 0) {
            return renderers.get(0);
        }
        return null;
    }

    public boolean rendererHasAccess(InetAddress callerIp) {
        Renderer renderer = this.getStoredRendererByIPAddress(callerIp);
        return renderer == null || renderer.isEnabled();
    }

    public List<Renderer> getStoredRenderers() {
        return this.rendererDao.findAll();
    }

    public void removeRenderer(String uuid) {
        this.rendererDao.delete(uuid);
        this.rendererUnavailable(uuid);
    }

    public void createRenderer(Renderer renderer) {
        this.rendererDao.create(renderer);
        log.info(String.format("Stored a new renderer: uuid='%s', name = '%s', ipAddress='%s', profile = '%s'", renderer.getUuid(), renderer.getName(), renderer.getIpAddress(), renderer.getProfileId()));
    }

    public Renderer getStoredRendererByUuid(String uuid) {
        return this.rendererDao.read(uuid);
    }

    public void updateRenderer(Renderer renderer) {
        this.rendererDao.update(renderer);
    }

    public void startExpirationChecker() {
        if (this.expirationChecker == null) {
            this.expirationChecker = new RendererExpirationChecker();
            Thread expirationCheckerThread = ServiioThreadFactory.getInstance().newThread(this.expirationChecker, "RendererExpirationChecker", true);
            expirationCheckerThread.setPriority(10);
            expirationCheckerThread.start();
        }
    }

    public void stopExpirationChecker() {
        if (this.expirationChecker != null) {
            this.expirationChecker.stopWorker();
        }
    }

    public Map<String, ActiveRenderer> getActiveRenderers() {
        return this.activeRenderers;
    }

    protected Renderer getProfileByRendererDescriptionFromURL(String uuid, String ipAddress, String serverName, String descriptionURL) throws CannotResolveRendererProfileException {
        log.debug(String.format("Retrieve device description from %s", descriptionURL));
        try {
            String descriptionXML = HttpClient.retrieveTextFileFromURL(descriptionURL, "UTF-8");
            Renderer renderer = this.getRendererByRendererDescription(uuid, ipAddress, serverName, descriptionXML);
            this.removeRendererWithIPAddress(ipAddress);
            this.createRenderer(renderer);
            return renderer;
        }
        catch (IOException e) {
            throw new CannotResolveRendererProfileException(String.format("Cannot retrieve device description from %s", descriptionURL), e);
        }
    }

    protected Renderer getRendererByRendererDescription(String uuid, String ipAddress, String serverName, String descriptionXML) throws CannotResolveRendererProfileException {
        try {
            Node rootNode = XPathUtil.getRootNode(descriptionXML);
            Node deviceNode = XPathUtil.getNode(rootNode, "d:root/d:device", nsContext);
            String nameSpacePrefix = "d:";
            if (deviceNode == null) {
                deviceNode = XPathUtil.getNode(rootNode, "root/device", nsContext);
                nameSpacePrefix = "";
            }
            String modelName = XPathUtil.getNodeValue(deviceNode, String.format("%smodelName", nameSpacePrefix), nsContext);
            String modelNumber = XPathUtil.getNodeValue(deviceNode, String.format("%smodelNumber", nameSpacePrefix), nsContext);
            String productCode = XPathUtil.getNodeValue(deviceNode, String.format("%sUPC", nameSpacePrefix), nsContext);
            String friendlyName = XPathUtil.getNodeValue(deviceNode, String.format("%sfriendlyName", nameSpacePrefix), nsContext);
            String manufacturer = XPathUtil.getNodeValue(deviceNode, String.format("%smanufacturer", nameSpacePrefix), nsContext);
            log.debug(String.format("Looking for a renderer profile for: friendly name = '%s', model name= '%s', model number = '%s', manufacturer = '%s', product code = '%s', server name = '%s'", friendlyName, modelName, modelNumber, manufacturer, productCode, serverName));
            Profile profileByDescription = ProfileManager.findProfileByDescription(friendlyName, modelName, modelNumber, productCode, serverName, manufacturer);
            Renderer renderer = new Renderer(uuid, ipAddress, modelName, null, false, false, Configuration.isRendererEnabledByDefault(), Configuration.getRendererDefaultAccessGroupId());
            if (profileByDescription != null) {
                renderer.setProfileId(profileByDescription.getId());
            } else {
                renderer.setProfileId("1");
            }
            return renderer;
        }
        catch (XPathExpressionException e) {
            throw new CannotResolveRendererProfileException("Cannot parse device description", e);
        }
    }

    private boolean updateRendererWithANewIPAddress(Renderer renderer, String ipAddress) {
        if (!ipAddress.equals(renderer.getIpAddress())) {
            this.removeRendererWithIPAddress(ipAddress);
            renderer.setIpAddress(ipAddress);
            this.rendererDao.update(renderer);
            return true;
        }
        return false;
    }

    private void removeRendererWithIPAddress(String ipAddress) {
        List<Renderer> existingRenderers = this.rendererDao.findByIPAddress(ipAddress);
        for (Renderer existingRenderer : existingRenderers) {
            this.removeRenderer(existingRenderer.getUuid());
        }
    }

    static {
        log = LoggerFactory.getLogger(RendererManager.class);
        nsContext = new UPnPDeviceNamespaceContext();
    }

    private static class UPnPDeviceNamespaceContext
    implements NamespaceContext {
        private UPnPDeviceNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("d")) {
                return "urn:schemas-upnp-org:device-1-0";
            }
            return "";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator<?> getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

