/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.renderer;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.serviio.renderer.ActiveRenderer;
import org.serviio.renderer.RendererManager;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererExpirationChecker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RendererExpirationChecker.class);
    private static final int CHECK_FREQUENCY = 5000;
    private boolean workerRunning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Starting RendererExpirationChecker");
        this.workerRunning = true;
        GregorianCalendar currentDate = new GregorianCalendar();
        while (this.workerRunning) {
            currentDate.setTime(new Date());
            Map<String, ActiveRenderer> renderersMap = RendererManager.getInstance().getActiveRenderers();
            Set<String> uuids = renderersMap.keySet();
            Map<String, ActiveRenderer> map = renderersMap;
            synchronized (map) {
                Iterator<String> i = uuids.iterator();
                while (i.hasNext()) {
                    String uuid = i.next();
                    ActiveRenderer activeRenderer = renderersMap.get(uuid);
                    int ttl = activeRenderer.getTimeToLive();
                    GregorianCalendar expirationDate = new GregorianCalendar();
                    expirationDate.setTime(activeRenderer.getLastUpdated());
                    ((Calendar)expirationDate).add(13, ttl);
                    if (expirationDate.compareTo(currentDate) >= 0) continue;
                    log.debug(String.format("Removing renderer %s from list of active renderers (expired)", uuid));
                    i.remove();
                }
            }
            ThreadUtils.currentThreadSleep(5000L);
        }
        log.info("Leaving RendererExpirationChecker");
    }

    public void stopWorker() {
        this.workerRunning = false;
    }
}

