/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.profile;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.serviio.MediaServer;
import org.serviio.delivery.resource.transcode.AudioTranscodingDefinition;
import org.serviio.delivery.resource.transcode.AudioTranscodingMatch;
import org.serviio.delivery.resource.transcode.ImageTranscodingDefinition;
import org.serviio.delivery.resource.transcode.ImageTranscodingMatch;
import org.serviio.delivery.resource.transcode.TranscodingConfiguration;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.resource.transcode.VideoTranscodingDefinition;
import org.serviio.delivery.resource.transcode.VideoTranscodingMatch;
import org.serviio.delivery.subtitles.SubtitlesConfiguration;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.AudioContainer;
import org.serviio.dlna.DisplayAspectRatio;
import org.serviio.dlna.H264Profile;
import org.serviio.dlna.ImageContainer;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.SamplingMode;
import org.serviio.dlna.ThumbnailResolution;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.DetectionDefinition;
import org.serviio.profile.H264LevelCheckType;
import org.serviio.profile.ImageResolutions;
import org.serviio.profile.OnlineContentType;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfilesDefinitionException;
import org.serviio.upnp.DeviceDescription;
import org.serviio.upnp.protocol.http.transport.ResourceTransportProtocolHandler;
import org.serviio.upnp.service.contentdirectory.ContentDirectoryMessageBuilder;
import org.serviio.upnp.service.contentdirectory.DLNAProtocolAdditionalInfo;
import org.serviio.upnp.service.contentdirectory.ProtocolAdditionalInfo;
import org.serviio.upnp.service.contentdirectory.ProtocolInfo;
import org.serviio.upnp.service.contentdirectory.SimpleProtocolInfo;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionFilter;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilesDefinitionParser {
    private static final Logger log = LoggerFactory.getLogger(ProfilesDefinitionParser.class);
    private static final String PROFILES_XSD = "Profiles.xsd";
    private static final String TAG_PROFILE = "Profile";
    private static final String TAG_CONTENT_DIRECTORY_MESSAGE_BUILDER = "ContentDirectoryMessageBuilder";
    private static final String TAG_RESOURCE_TRANSPORT_PROTOCOL_HANDLER = "ResourceTransportProtocolHandler";
    private static final String TAG_CONTENT_DIRECTORY_DEFINITION_FILTER = "ContentDirectoryDefinitionFilter";
    private static final String TAG_DETECTION = "Detection";
    private static final String TAG_PROTOCOL_INFO = "ProtocolInfo";
    private static final String TAG_MEDIA_PROFILES = "MediaFormatProfiles";
    private static final String TAG_MEDIA_PROFILE = "MediaFormatProfile";
    private static final String TAG_DEVICE_DESCRIPTION = "DeviceDescription";
    private static final String TAG_UPNP_SEARCH = "UPnPSearch";
    private static final String TAG_HTTP_HEADERS = "HttpHeaders";
    private static final String TAG_FRIENDLY_NAME = "FriendlyName";
    private static final String TAG_MODEL_NAME = "ModelName";
    private static final String TAG_MODEL_NUMBER = "ModelNumber";
    private static final String TAG_MANUFACTURER = "Manufacturer";
    private static final String TAG_EXTRA_ELEMENTS = "ExtraElements";
    private static final String TAG_TRANSCODING = "Transcoding";
    private static final String TAG_ONLINE_TRANSCODING = "OnlineTranscoding";
    private static final String TAG_HARDSUBS_TRANSCODING = "HardSubsTranscoding";
    private static final String TAG_ALTERNATIVE_QUALITIES = "AlternativeQualities";
    private static final String TAG_QUALITY = "Quality";
    private static final String TAG_TRANSCODING_VIDEO = "Video";
    private static final String TAG_TRANSCODING_AUDIO = "Audio";
    private static final String TAG_TRANSCODING_IMAGE = "Image";
    private static final String TAG_TRANSCODING_MATCHES = "Matches";
    private static final String TAG_AUTOMATIC_IMAGE_ROTATION = "AutomaticImageRotation";
    private static final String TAG_LIMIT_IMAGE_RESOLUTION = "LimitImageResolution";
    private static final String TAG_AVAILABLE_IMAGE_RESOLUTIONS = "AllowedImageResolutions";
    private static final String TAG_H264_LEVEL_CHECK = "H264LevelCheck";
    private static final String TAG_SUBTITLES = "Subtitles";
    private static final String TAG_SUBTITLES_HARDSUBS = "HardSubs";
    private static final String TAG_SUBTITLES_HARDSUBS_REQUIRED_FOR = "RequiredFor";
    private static final String TAG_SUBTITLES_SOFTSUBS = "SoftSubs";
    private static final String TAG_THUMBNAILS_RESOLUTION = "ThumbnailsResolution";
    private static final String PROTOCOL_INFO_SIMPLE = "simple";
    private static final String PROTOCOL_INFO_DLNA = "DLNA";
    private static final String COMP_NAME_VARIABLE = "\\{computerName\\}";
    private static String COMP_NAME;

    public static List<Profile> parseDefinition(InputStream definitionStream, List<Profile> currentProfiles) throws ProfilesDefinitionException {
        if (definitionStream == null) {
            throw new ProfilesDefinitionException("Profiles definition is not present.");
        }
        try {
            String xml = StringUtils.readStreamAsString(definitionStream, "UTF-8");
            ProfilesDefinitionParser.validateXML(xml);
            Document document = ProfilesDefinitionParser.parser(xml);
            Element profilesNode = document.getRootElement();
            if (profilesNode == null) {
                throw new ProfilesDefinitionException("Profiles definition doesn't contain a root Profiles node.");
            }
            log.info("Parsing Profiles definition");
            ArrayList<Profile> profiles = new ArrayList<Profile>(currentProfiles);
            List profileNodes = profilesNode.getChildren(TAG_PROFILE);
            for (int i = 0; i < profileNodes.size(); ++i) {
                Profile profile = ProfilesDefinitionParser.processProfileNode((Element)profileNodes.get(i), profiles);
                profiles.add(profile);
            }
            return profiles;
        }
        catch (JDOMException e) {
            throw new ProfilesDefinitionException(String.format("Cannot read Profiles XML. Reason: %s", e.getMessage()));
        }
        catch (IOException e) {
            throw new ProfilesDefinitionException(String.format("Cannot read Profiles XML. Reason: %s", e.getMessage()));
        }
    }

    private static Document parser(String xmlDocument) throws IOException, JDOMException {
        SAXBuilder saxBuilder = new SAXBuilder();
        return saxBuilder.build((Reader)new StringReader(xmlDocument));
    }

    private static Profile processProfileNode(Element profileNode, List<Profile> profiles) throws ProfilesDefinitionException {
        String id = profileNode.getAttributeValue("id");
        if (ObjectValidator.isNotEmpty(id)) {
            Map<MediaFormatProfile, ProtocolInfo> protocolInfos;
            log.debug(String.format("Parsing profile definition for profile %s", id));
            if (ProfilesDefinitionParser.getProfileById(profiles, id) != null) {
                throw new ProfilesDefinitionException(String.format("Duplicate profile id %s", id));
            }
            Profile parentProfile = null;
            String extendsProfileId = profileNode.getAttributeValue("extendsProfileId");
            if (ObjectValidator.isNotEmpty(extendsProfileId) && (parentProfile = ProfilesDefinitionParser.getProfileById(profiles, extendsProfileId)) == null) {
                throw new ProfilesDefinitionException(String.format("Profile %s cannot find profile with id %s to extend from. The parent profile must be defined before this profile.", id, extendsProfileId));
            }
            String h264LevelCheckTypeValue = profileNode.getChildText(TAG_H264_LEVEL_CHECK);
            H264LevelCheckType h264LevelCheckType = null;
            if (ObjectValidator.isNotEmpty(h264LevelCheckTypeValue)) {
                h264LevelCheckType = H264LevelCheckType.valueOf(h264LevelCheckTypeValue);
            }
            h264LevelCheckType = h264LevelCheckType == null && parentProfile != null ? parentProfile.getH264LevelCheck() : h264LevelCheckType;
            String name = profileNode.getAttributeValue("name");
            List<DetectionDefinition> detectionDefinitions = ProfilesDefinitionParser.getDetectionDefinitions(id, profileNode);
            Class<?> cdMessageBuilderClass = ProfilesDefinitionParser.getContentDirectoryMessageBuilderClass(id, profileNode);
            ResourceTransportProtocolHandler resourceTrasportProtocolHandler = ProfilesDefinitionParser.getResourceTransportProtocolHandler(id, profileNode);
            ContentDirectoryDefinitionFilter contentDirectoryDefinitionFilter = ProfilesDefinitionParser.getContentDirectoryDefinitionFilter(id, profileNode);
            TranscodingConfiguration onlineTranscodeConfig = ProfilesDefinitionParser.getTranscodingConfiguration(id, profileNode.getChild(TAG_ONLINE_TRANSCODING), parentProfile != null ? parentProfile.getDefaultDeliveryQuality().getOnlineTranscodingConfiguration() : null, h264LevelCheckType, false, true);
            TranscodingConfiguration transcodeConfig = ProfilesDefinitionParser.getTranscodingConfiguration(id, profileNode.getChild(TAG_TRANSCODING), parentProfile != null ? parentProfile.getDefaultDeliveryQuality().getTranscodingConfiguration() : null, h264LevelCheckType, false, false);
            TranscodingConfiguration hardSubsTranscodeConfig = ProfilesDefinitionParser.getTranscodingConfiguration(id, profileNode.getChild(TAG_HARDSUBS_TRANSCODING), parentProfile != null ? parentProfile.getDefaultDeliveryQuality().getHardSubsTranscodingConfiguration() : null, h264LevelCheckType, true, true);
            DeviceDescription deviceDescription = ProfilesDefinitionParser.getDeviceDescription(id, profileNode, parentProfile);
            SubtitlesConfiguration subtitlesConfiguration = ProfilesDefinitionParser.getSubtitlesConfig(id, profileNode);
            String protocolInfoType = profileNode.getChildTextTrim(TAG_PROTOCOL_INFO);
            String automaticImageRotation = profileNode.getChildTextTrim(TAG_AUTOMATIC_IMAGE_ROTATION);
            String limitImageResolution = profileNode.getChildTextTrim(TAG_LIMIT_IMAGE_RESOLUTION);
            String thumbnailsResolutionType = profileNode.getChildTextTrim(TAG_THUMBNAILS_RESOLUTION);
            String alwaysEnableTranscoding = profileNode.getAttributeValue("alwaysEnableTranscoding");
            String selectable = profileNode.getAttributeValue("selectable");
            if (ObjectValidator.isEmpty(protocolInfoType)) {
                protocolInfoType = null;
            }
            protocolInfoType = protocolInfoType == null && parentProfile != null ? parentProfile.getProtocolInfoType() : protocolInfoType;
            ThumbnailResolution thumbnailsResolution = thumbnailsResolutionType == null && parentProfile != null ? parentProfile.getThumbnailsResolution() : ThumbnailResolution.valueOf(thumbnailsResolutionType);
            Profile profile = new Profile(id, name, cdMessageBuilderClass == null && parentProfile != null ? parentProfile.getContentDirectoryMessageBuilder() : cdMessageBuilderClass, resourceTrasportProtocolHandler == null && parentProfile != null ? parentProfile.getResourceTransportProtocolHandler() : resourceTrasportProtocolHandler, detectionDefinitions, protocolInfos = ProfilesDefinitionParser.getProtocolInfoMap(id, profileNode, protocolInfoType, parentProfile), protocolInfoType, deviceDescription, contentDirectoryDefinitionFilter == null && parentProfile != null ? parentProfile.getContentDirectoryDefinitionFilter() : contentDirectoryDefinitionFilter, transcodeConfig, onlineTranscodeConfig, hardSubsTranscodeConfig, ObjectValidator.isEmpty(automaticImageRotation) && parentProfile != null ? parentProfile.isAutomaticImageRotation() : Boolean.parseBoolean(automaticImageRotation), ObjectValidator.isEmpty(limitImageResolution) && parentProfile != null ? parentProfile.isLimitImageResolution() : Boolean.parseBoolean(limitImageResolution), subtitlesConfiguration == null && parentProfile != null ? parentProfile.getSubtitlesConfiguration() : subtitlesConfiguration, Boolean.parseBoolean(alwaysEnableTranscoding), selectable != null ? Boolean.parseBoolean(selectable) : true, ProfilesDefinitionParser.getAlternativeDeliveryQualities(id, profileNode, h264LevelCheckType), h264LevelCheckType, thumbnailsResolution, ProfilesDefinitionParser.getAllowedImageResolutions(profileNode, parentProfile));
            if (ProfilesDefinitionParser.validateProfile(profile)) {
                log.info(String.format("Added profile '%s' (id=%s)", name, id));
                return profile;
            }
            throw new ProfilesDefinitionException("Profile validation failed. Check the log.");
        }
        throw new ProfilesDefinitionException("Invalid profiles definition. A profile is missing id attribute.");
    }

    private static Class<?> getContentDirectoryMessageBuilderClass(String profileId, Element profileNode) throws ProfilesDefinitionException {
        String className = profileNode.getChildTextTrim(TAG_CONTENT_DIRECTORY_MESSAGE_BUILDER);
        if (ObjectValidator.isNotEmpty(className)) {
            try {
                Class<?> clazz = Class.forName(className.trim());
                if (!ContentDirectoryMessageBuilder.class.isAssignableFrom(clazz)) {
                    throw new ProfilesDefinitionException(String.format("Class %s defining ContentDirectoryMessageBuilder for profile %s is not of a proper type", className, profileId));
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new ProfilesDefinitionException(String.format("Class %s defining ContentDirectoryMessageBuilder of profile %s does not exist", className, profileId));
            }
        }
        return null;
    }

    private static ResourceTransportProtocolHandler getResourceTransportProtocolHandler(String profileId, Element profileNode) throws ProfilesDefinitionException {
        String className = profileNode.getChildTextTrim(TAG_RESOURCE_TRANSPORT_PROTOCOL_HANDLER);
        if (ObjectValidator.isNotEmpty(className)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (!ResourceTransportProtocolHandler.class.isAssignableFrom(clazz)) {
                    throw new ProfilesDefinitionException(String.format("Class %s defining ResourceTransportProtocolHandler for profile %s is not of a proper type", className, profileId));
                }
                return (ResourceTransportProtocolHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ProfilesDefinitionException(String.format("Class %s defining ResourceTransportProtocolHandler of profile %s does not exist", className, profileId));
            }
            catch (InstantiationException e) {
                throw new ProfilesDefinitionException(String.format("Cannot instantiate ResourceTransportProtocolHandler of profile %s", profileId));
            }
            catch (IllegalAccessException e) {
                throw new ProfilesDefinitionException(String.format("Cannot instantiate ResourceTransportProtocolHandler of profile %s", profileId));
            }
        }
        return null;
    }

    private static ContentDirectoryDefinitionFilter getContentDirectoryDefinitionFilter(String profileId, Element profileNode) throws ProfilesDefinitionException {
        String className = profileNode.getChildTextTrim(TAG_CONTENT_DIRECTORY_DEFINITION_FILTER);
        if (ObjectValidator.isNotEmpty(className)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (!ContentDirectoryDefinitionFilter.class.isAssignableFrom(clazz)) {
                    throw new ProfilesDefinitionException(String.format("Class %s defining ContentDirectoryDefinitionFilter for profile %s is not of a proper type", className, profileId));
                }
                return (ContentDirectoryDefinitionFilter)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ProfilesDefinitionException(String.format("Class %s defining ContentDirectoryDefinitionFilter of profile %s does not exist", className, profileId));
            }
            catch (InstantiationException e) {
                throw new ProfilesDefinitionException(String.format("Cannot instantiate ContentDirectoryDefinitionFilter of profile %s", profileId));
            }
            catch (IllegalAccessException e) {
                throw new ProfilesDefinitionException(String.format("Cannot instantiate ContentDirectoryDefinitionFilter of profile %s", profileId));
            }
        }
        return null;
    }

    private static DeviceDescription getDeviceDescription(String profileId, Element profileNode, Profile parentProfile) throws ProfilesDefinitionException {
        Element ddNode = profileNode.getChild(TAG_DEVICE_DESCRIPTION);
        if (ddNode != null) {
            String extraElements;
            String manufacturer;
            String modelNumber;
            String friendlyName = ddNode.getChildTextTrim(TAG_FRIENDLY_NAME);
            friendlyName = friendlyName != null ? friendlyName.replaceFirst(COMP_NAME_VARIABLE, COMP_NAME) : (parentProfile != null ? parentProfile.getDeviceDescription().getFriendlyName() : null);
            String modelName = ddNode.getChildTextTrim(TAG_MODEL_NAME);
            if (modelName == null) {
                String string = modelName = parentProfile != null ? parentProfile.getDeviceDescription().getModelName() : null;
            }
            if ((modelNumber = ddNode.getChildTextTrim(TAG_MODEL_NUMBER)) == null) {
                String string = modelNumber = parentProfile != null ? parentProfile.getDeviceDescription().getModelNumber() : null;
            }
            if ((manufacturer = ddNode.getChildTextTrim(TAG_MANUFACTURER)) == null) {
                String string = manufacturer = parentProfile != null ? parentProfile.getDeviceDescription().getManufacturer() : null;
            }
            extraElements = (extraElements = ddNode.getChildTextTrim(TAG_EXTRA_ELEMENTS)) == null ? (parentProfile != null ? parentProfile.getDeviceDescription().getExtraElements() : null) : XmlUtils.decodeXml(extraElements.trim());
            if (ObjectValidator.isNotEmpty(friendlyName) && ObjectValidator.isNotEmpty(modelName) && ObjectValidator.isNotEmpty(manufacturer)) {
                String number = ObjectValidator.isEmpty(modelNumber) ? MediaServer.VERSION : modelNumber;
                return new DeviceDescription(friendlyName, modelName, number, manufacturer, extraElements);
            }
            throw new ProfilesDefinitionException(String.format("Profile %s has incomplete device description", profileId));
        }
        return parentProfile.getDeviceDescription();
    }

    private static ImageResolutions getAllowedImageResolutions(Element profileNode, Profile parentProfile) throws ProfilesDefinitionException {
        Element airNode = profileNode.getChild(TAG_AVAILABLE_IMAGE_RESOLUTIONS);
        if (airNode != null) {
            return new ImageResolutions(airNode.getAttributeValue("large"), airNode.getAttributeValue("medium"), airNode.getAttributeValue("small"));
        }
        if (parentProfile != null) {
            return parentProfile.getAllowedImageResolutions();
        }
        throw new ProfilesDefinitionException("Missing element AllowedImageResolutions");
    }

    private static List<DetectionDefinition> getDetectionDefinitions(String profileId, Element profileNode) throws ProfilesDefinitionException {
        Element ddNode = profileNode.getChild(TAG_DETECTION);
        if (ddNode != null) {
            DetectionDefinition dd;
            ArrayList<DetectionDefinition> result = new ArrayList<DetectionDefinition>();
            Element upnpSearchNode = ddNode.getChild(TAG_UPNP_SEARCH);
            Element httpHeadersNode = ddNode.getChild(TAG_HTTP_HEADERS);
            if (upnpSearchNode != null) {
                dd = new DetectionDefinition(DetectionDefinition.DetectionType.UPNP_SEARCH);
                dd.getFieldValues().putAll(ProfilesDefinitionParser.getAllDetectionFields(upnpSearchNode));
                result.add(dd);
            }
            if (httpHeadersNode != null) {
                dd = new DetectionDefinition(DetectionDefinition.DetectionType.HTTP_HEADERS);
                dd.getFieldValues().putAll(ProfilesDefinitionParser.getAllDetectionFields(httpHeadersNode));
                result.add(dd);
            }
            return result;
        }
        return null;
    }

    private static Map<String, String> getAllDetectionFields(Element parentNode) {
        List headerNodes = parentNode.getChildren();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < headerNodes.size(); ++i) {
            Element headerNode = (Element)headerNodes.get(i);
            headers.put(headerNode.getName(), headerNode.getTextTrim());
        }
        return headers;
    }

    private static TranscodingConfiguration getTranscodingConfiguration(String profileId, Element trNode, TranscodingConfiguration parentTranscodingConfig, H264LevelCheckType h264LevelCheck, boolean addDefaultMatcher, boolean inherits) throws ProfilesDefinitionException {
        if (trNode == null && inherits) {
            return parentTranscodingConfig;
        }
        if (trNode != null || ProfilesDefinitionParser.transcodingConfigIncludesForcedItems(parentTranscodingConfig)) {
            String keepStreamOpenValue;
            boolean keepStreamOpen;
            TranscodingConfiguration trConfig = new TranscodingConfiguration();
            boolean bl = keepStreamOpen = parentTranscodingConfig != null && trNode == null ? parentTranscodingConfig.isKeepStreamOpen() : true;
            if (trNode != null && ObjectValidator.isNotEmpty(keepStreamOpenValue = trNode.getAttributeValue("keepStreamOpen"))) {
                keepStreamOpen = Boolean.valueOf(keepStreamOpenValue);
            }
            trConfig.setKeepStreamOpen(keepStreamOpen);
            ProfilesDefinitionParser.getVideoTranscodingConfiguration(profileId, trNode, trConfig, parentTranscodingConfig, h264LevelCheck, addDefaultMatcher);
            ProfilesDefinitionParser.getAudioTranscodingConfiguration(profileId, trNode, trConfig, parentTranscodingConfig);
            ProfilesDefinitionParser.getImageTranscodingConfiguration(profileId, trNode, trConfig, parentTranscodingConfig);
            return trConfig;
        }
        return null;
    }

    private static void getVideoTranscodingConfiguration(String profileId, Element trNode, TranscodingConfiguration trConfig, TranscodingConfiguration parentTrConfig, H264LevelCheckType h264LevelCheck, boolean addDefaultMatcher) throws ProfilesDefinitionException {
        if (trNode != null) {
            List videoNodes = trNode.getChildren(TAG_TRANSCODING_VIDEO);
            for (int i = 0; i < videoNodes.size(); ++i) {
                Element videoNode = (Element)videoNodes.get(i);
                VideoContainer targetContainer = VideoContainer.getByFFmpegValue(videoNode.getAttributeValue("targetContainer"), null);
                if (targetContainer == null) {
                    throw new ProfilesDefinitionException(String.format("Profile %s has unsupported target container in video transcoding definition", profileId));
                }
                String vCodecName = videoNode.getAttributeValue("targetVCodec");
                String aCodecName = videoNode.getAttributeValue("targetACodec");
                String maxVideoBitrateValue = videoNode.getAttributeValue("maxVBitrate");
                String maxHeightValue = videoNode.getAttributeValue("maxHeight");
                String audioBitrateValue = videoNode.getAttributeValue("aBitrate");
                String audioSampleRateValue = videoNode.getAttributeValue("aSamplerate");
                String forceVTranscodingValue = videoNode.getAttributeValue("forceVTranscoding");
                String forceStereoValue = videoNode.getAttributeValue("forceStereo");
                String forceInheritanceValue = videoNode.getAttributeValue("forceInheritance");
                String darName = videoNode.getAttributeValue("DAR");
                VideoCodec targetVCodec = null;
                AudioCodec targetACodec = null;
                Integer maxVideoBitrate = null;
                Integer maxHeight = null;
                Integer audioBitrate = null;
                Integer audioSamplerate = null;
                Boolean forceVTranscoding = Boolean.FALSE;
                Boolean forceStereo = Boolean.FALSE;
                Boolean forceInheritance = Boolean.FALSE;
                DisplayAspectRatio dar = null;
                if (ObjectValidator.isNotEmpty(vCodecName) && (targetVCodec = VideoCodec.getByFFmpegValue(vCodecName)) == null) {
                    throw new ProfilesDefinitionException(String.format("Profile %s has unsupported target video codec '%s' in transcoding definition", profileId, vCodecName));
                }
                if (ObjectValidator.isNotEmpty(aCodecName) && (targetACodec = AudioCodec.getByFFmpegDecoderName(aCodecName, null)) == null) {
                    throw new ProfilesDefinitionException(String.format("Profile %s has unsupported target audio codec '%s' in transcoding definition", profileId, aCodecName));
                }
                if (ObjectValidator.isNotEmpty(maxVideoBitrateValue)) {
                    maxVideoBitrate = Integer.valueOf(maxVideoBitrateValue);
                }
                if (ObjectValidator.isNotEmpty(maxHeightValue)) {
                    maxHeight = Integer.valueOf(maxHeightValue);
                }
                if (ObjectValidator.isNotEmpty(audioBitrateValue)) {
                    audioBitrate = Integer.valueOf(audioBitrateValue);
                }
                if (ObjectValidator.isNotEmpty(audioSampleRateValue)) {
                    audioSamplerate = Integer.valueOf(audioSampleRateValue);
                }
                if (ObjectValidator.isNotEmpty(forceVTranscodingValue)) {
                    forceVTranscoding = Boolean.valueOf(forceVTranscodingValue);
                }
                if (ObjectValidator.isNotEmpty(forceStereoValue)) {
                    forceStereo = Boolean.valueOf(forceStereoValue);
                }
                if (ObjectValidator.isNotEmpty(forceInheritanceValue)) {
                    forceInheritance = Boolean.valueOf(forceInheritanceValue);
                }
                if (ObjectValidator.isNotEmpty(darName)) {
                    dar = DisplayAspectRatio.fromString(darName);
                }
                VideoTranscodingDefinition td = new VideoTranscodingDefinition(trConfig, targetContainer, targetVCodec, targetACodec, maxVideoBitrate, maxHeight, audioBitrate, audioSamplerate, forceVTranscoding, forceStereo, forceInheritance, dar);
                List matcherNodes = videoNode.getChildren(TAG_TRANSCODING_MATCHES);
                for (int j = 0; j < matcherNodes.size(); ++j) {
                    Element matcherNode = (Element)matcherNodes.get(j);
                    VideoContainer container = VideoContainer.getByFFmpegValue(matcherNode.getAttributeValue("container"), null);
                    if (container == null) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has unsupported matcher video container in transcoding definition", profileId));
                    }
                    String vcName = matcherNode.getAttributeValue("vCodec");
                    String acName = matcherNode.getAttributeValue("aCodec");
                    String h264ProfileName = matcherNode.getAttributeValue("profile");
                    String h264LevelGTValue = matcherNode.getAttributeValue("levelGreaterThan");
                    String ftypNotInValue = matcherNode.getAttributeValue("ftypNotIn");
                    String vFourCCValue = matcherNode.getAttributeValue("vFourCC");
                    String squarePixelsValue = matcherNode.getAttributeValue("squarePixels");
                    String onlineContentTypeValue = matcherNode.getAttributeValue("contentType");
                    H264Profile h264Profile = null;
                    Float h264LevelGT = null;
                    VideoCodec vCodec = null;
                    AudioCodec aCodec = null;
                    Boolean squarePixels = null;
                    OnlineContentType onlineContentType = OnlineContentType.ANY;
                    if (ObjectValidator.isNotEmpty(vcName) && (vCodec = VideoCodec.getByFFmpegValue(vcName)) == null) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has unsupported video codec '%s' in transcoding definition", profileId, vcName));
                    }
                    if (ObjectValidator.isNotEmpty(acName) && (aCodec = AudioCodec.getByFFmpegDecoderName(acName, null)) == null) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has unsupported audio codec '%s' in transcoding definition", profileId, acName));
                    }
                    if (ObjectValidator.isNotEmpty(h264ProfileName)) {
                        h264Profile = H264Profile.valueOf(StringUtils.localeSafeToUppercase(h264ProfileName));
                    }
                    if (ObjectValidator.isNotEmpty(h264LevelGTValue)) {
                        h264LevelGT = new Float(h264LevelGTValue);
                    }
                    if (ObjectValidator.isNotEmpty(onlineContentTypeValue)) {
                        onlineContentType = OnlineContentType.valueOf(StringUtils.localeSafeToUppercase(onlineContentTypeValue));
                    }
                    if (ObjectValidator.isNotEmpty(squarePixelsValue)) {
                        squarePixels = new Boolean(squarePixelsValue);
                    }
                    td.getMatches().add(new VideoTranscodingMatch(container, vCodec, aCodec, h264Profile, h264LevelGT, StringUtils.localeSafeToLowercase(ftypNotInValue), onlineContentType, squarePixels, StringUtils.localeSafeToLowercase(vFourCCValue), h264LevelCheck));
                }
                if (addDefaultMatcher) {
                    td.getMatches().add(new VideoTranscodingMatch(VideoContainer.ANY));
                }
                trConfig.addDefinition(MediaFileType.VIDEO, td);
            }
        }
        ProfilesDefinitionParser.addInheritedTranscodingConfigs(MediaFileType.VIDEO, trConfig, parentTrConfig);
    }

    private static void getAudioTranscodingConfiguration(String profileId, Element trNode, TranscodingConfiguration trConfig, TranscodingConfiguration parentTrConfig) throws ProfilesDefinitionException {
        if (trNode != null) {
            List audioNodes = trNode.getChildren(TAG_TRANSCODING_AUDIO);
            for (int i = 0; i < audioNodes.size(); ++i) {
                Element audioNode = (Element)audioNodes.get(i);
                AudioContainer targetContainer = AudioContainer.getByName(audioNode.getAttributeValue("targetContainer"));
                if (targetContainer == null) {
                    throw new ProfilesDefinitionException(String.format("Profile %s has unsupported target container in audio transcoding definition", profileId));
                }
                String audioBitrateValue = audioNode.getAttributeValue("aBitrate");
                String audioSampleRateValue = audioNode.getAttributeValue("aSamplerate");
                String forceInheritanceValue = audioNode.getAttributeValue("forceInheritance");
                Integer audioBitrate = null;
                Integer audioSamplerate = null;
                Boolean forceInheritance = Boolean.FALSE;
                if (ObjectValidator.isNotEmpty(audioBitrateValue)) {
                    audioBitrate = Integer.valueOf(audioBitrateValue);
                }
                if (ObjectValidator.isNotEmpty(audioSampleRateValue)) {
                    audioSamplerate = Integer.valueOf(audioSampleRateValue);
                }
                if (ObjectValidator.isNotEmpty(forceInheritanceValue)) {
                    forceInheritance = Boolean.valueOf(forceInheritanceValue);
                }
                AudioTranscodingDefinition td = new AudioTranscodingDefinition(trConfig, targetContainer, audioBitrate, audioSamplerate, forceInheritance);
                List matcherNodes = audioNode.getChildren(TAG_TRANSCODING_MATCHES);
                for (int j = 0; j < matcherNodes.size(); ++j) {
                    Element matcherNode = (Element)matcherNodes.get(j);
                    AudioContainer container = AudioContainer.getByName(matcherNode.getAttributeValue("container"));
                    if (container == null) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has unsupported matcher audio container in transcoding definition", profileId));
                    }
                    String onlineContentTypeValue = matcherNode.getAttributeValue("contentType");
                    OnlineContentType onlineContentType = OnlineContentType.ANY;
                    if (ObjectValidator.isNotEmpty(onlineContentTypeValue)) {
                        onlineContentType = OnlineContentType.valueOf(StringUtils.localeSafeToUppercase(onlineContentTypeValue));
                    }
                    td.getMatches().add(new AudioTranscodingMatch(container, onlineContentType));
                }
                trConfig.addDefinition(MediaFileType.AUDIO, td);
            }
        }
        ProfilesDefinitionParser.addInheritedTranscodingConfigs(MediaFileType.AUDIO, trConfig, parentTrConfig);
    }

    private static void getImageTranscodingConfiguration(String profileId, Element trNode, TranscodingConfiguration trConfig, TranscodingConfiguration parentTrConfig) throws ProfilesDefinitionException {
        if (trNode != null) {
            List imageNodes = trNode.getChildren(TAG_TRANSCODING_IMAGE);
            for (int i = 0; i < imageNodes.size(); ++i) {
                Element imageNode = (Element)imageNodes.get(i);
                String forceInheritanceValue = imageNode.getAttributeValue("forceInheritance");
                Boolean forceInheritance = Boolean.FALSE;
                if (ObjectValidator.isNotEmpty(forceInheritanceValue)) {
                    forceInheritance = Boolean.valueOf(forceInheritanceValue);
                }
                ImageTranscodingDefinition td = new ImageTranscodingDefinition(trConfig, forceInheritance);
                List matcherNodes = imageNode.getChildren(TAG_TRANSCODING_MATCHES);
                for (int j = 0; j < matcherNodes.size(); ++j) {
                    Element matcherNode = (Element)matcherNodes.get(j);
                    ImageContainer container = ImageContainer.getByName(matcherNode.getAttributeValue("container"));
                    if (container == null) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has unsupported matcher image container in transcoding definition", profileId));
                    }
                    String subsamplingValue = matcherNode.getAttributeValue("subsampling");
                    SamplingMode samplingMode = null;
                    if (ObjectValidator.isNotEmpty(subsamplingValue)) {
                        samplingMode = SamplingMode.valueOf(subsamplingValue);
                    }
                    td.getMatches().add(new ImageTranscodingMatch(container, samplingMode));
                }
                trConfig.addDefinition(MediaFileType.IMAGE, td);
            }
        }
        ProfilesDefinitionParser.addInheritedTranscodingConfigs(MediaFileType.IMAGE, trConfig, parentTrConfig);
    }

    private static void addInheritedTranscodingConfigs(MediaFileType type, TranscodingConfiguration trConfig, TranscodingConfiguration parentTrConfig) {
        if (parentTrConfig != null) {
            for (TranscodingDefinition td : parentTrConfig.getDefinitions(type)) {
                if (!td.isForceInheritance()) continue;
                trConfig.addDefinition(type, td);
            }
        }
    }

    private static boolean transcodingConfigIncludesForcedItems(TranscodingConfiguration trConfig) {
        if (trConfig != null) {
            for (TranscodingDefinition def : trConfig.getDefinitions()) {
                if (!def.isForceInheritance()) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<MediaFormatProfile, ProtocolInfo> getProtocolInfoMap(String profileId, Element profileNode, String protocolInfoType, Profile parentProfile) throws ProfilesDefinitionException {
        LinkedHashMap<MediaFormatProfile, ProtocolInfo> protocolInfos = new LinkedHashMap<MediaFormatProfile, ProtocolInfo>();
        if (parentProfile != null && ObjectValidator.isEmpty(protocolInfoType)) {
            protocolInfoType = parentProfile.getProtocolInfoType();
        }
        if (ObjectValidator.isNotEmpty(protocolInfoType)) {
            Element formatsNode = profileNode.getChild(TAG_MEDIA_PROFILES);
            if (formatsNode != null) {
                List formatNodes = formatsNode.getChildren(TAG_MEDIA_PROFILE);
                for (int i = 0; i < formatNodes.size(); ++i) {
                    Element formatNode = (Element)formatNodes.get(i);
                    String mimeType = formatNode.getAttributeValue("mime-type");
                    String formatName = formatNode.getTextTrim();
                    if (ObjectValidator.isEmpty(mimeType)) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has invalid (missing mime-type) media format profile", profileId));
                    }
                    if (ObjectValidator.isEmpty(formatName)) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has invalid (missing value) media format profile", profileId));
                    }
                    try {
                        MediaFormatProfile formatProfile = MediaFormatProfile.valueOf(formatName);
                        String profileFormatNames = formatNode.getAttributeValue("name");
                        List<? extends ProtocolAdditionalInfo> protocolAdditionalInfos = ProfilesDefinitionParser.createProtocolInfos(profileId, protocolInfoType, formatProfile, profileFormatNames);
                        protocolInfos.put(formatProfile, new ProtocolInfo(mimeType, protocolAdditionalInfos));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has invalid media format profile %s", profileId, formatName));
                    }
                }
            }
            if (parentProfile != null) {
                for (Map.Entry<MediaFormatProfile, ProtocolInfo> parentPI : parentProfile.getProtocolInfo().entrySet()) {
                    if (protocolInfos.containsKey((Object)parentPI.getKey())) continue;
                    if (parentProfile.getProtocolInfoType().equals(protocolInfoType)) {
                        protocolInfos.put(parentPI.getKey(), parentPI.getValue());
                        continue;
                    }
                    List<? extends ProtocolAdditionalInfo> protocolAdditionalInfos = ProfilesDefinitionParser.createProtocolInfos(profileId, protocolInfoType, parentPI.getKey(), null);
                    protocolInfos.put(parentPI.getKey(), new ProtocolInfo(parentPI.getValue().getMimeType(), protocolAdditionalInfos));
                }
            }
        }
        return protocolInfos;
    }

    private static List<? extends ProtocolAdditionalInfo> createProtocolInfos(String profileId, String protocolInfoType, MediaFormatProfile formatProfile, String profileFormatNames) throws ProfilesDefinitionException {
        if (protocolInfoType.equals(PROTOCOL_INFO_SIMPLE)) {
            return Collections.singletonList(new SimpleProtocolInfo());
        }
        if (protocolInfoType.equals(PROTOCOL_INFO_DLNA)) {
            String[] names;
            if (ObjectValidator.isEmpty(profileFormatNames)) {
                String profileFormatName = profileFormatNames != null ? null : formatProfile.toString();
                return Collections.singletonList(new DLNAProtocolAdditionalInfo(profileFormatName));
            }
            ArrayList<DLNAProtocolAdditionalInfo> protocolAdditionalInfos = new ArrayList<DLNAProtocolAdditionalInfo>();
            for (String name : names = profileFormatNames.split(",")) {
                protocolAdditionalInfos.add(new DLNAProtocolAdditionalInfo(name.trim()));
            }
            return protocolAdditionalInfos;
        }
        throw new ProfilesDefinitionException(String.format("Profile %s has invalid (%s) type of ProtocolInfo", profileId));
    }

    private static Profile getProfileById(List<Profile> profiles, String profileId) {
        for (Profile profile : profiles) {
            if (!profile.getId().equals(profileId)) continue;
            return profile;
        }
        return null;
    }

    private static List<DeliveryQuality> getAlternativeDeliveryQualities(String profileId, Element profileNode, H264LevelCheckType h264LevelCheck) throws ProfilesDefinitionException {
        Element qualitiesNode = profileNode.getChild(TAG_ALTERNATIVE_QUALITIES);
        ArrayList<DeliveryQuality> qualities = new ArrayList<DeliveryQuality>();
        if (qualitiesNode != null) {
            List qualityNodes = qualitiesNode.getChildren(TAG_QUALITY);
            for (Element qualityNode : qualityNodes) {
                TranscodingConfiguration onlineTranscodeConfig = ProfilesDefinitionParser.getTranscodingConfiguration(profileId, qualityNode.getChild(TAG_ONLINE_TRANSCODING), null, h264LevelCheck, false, false);
                TranscodingConfiguration transcodeConfig = ProfilesDefinitionParser.getTranscodingConfiguration(profileId, qualityNode.getChild(TAG_TRANSCODING), null, h264LevelCheck, false, false);
                TranscodingConfiguration hardSubsTranscodeConfig = ProfilesDefinitionParser.getTranscodingConfiguration(profileId, qualityNode.getChild(TAG_HARDSUBS_TRANSCODING), null, h264LevelCheck, true, false);
                DeliveryQuality.QualityType type = DeliveryQuality.QualityType.valueOf(qualityNode.getAttributeValue("type"));
                qualities.add(new DeliveryQuality(type, transcodeConfig, onlineTranscodeConfig, hardSubsTranscodeConfig));
            }
        }
        return qualities;
    }

    private static SubtitlesConfiguration getSubtitlesConfig(String profileId, Element profileNode) throws ProfilesDefinitionException {
        Element subtitlesNode = profileNode.getChild(TAG_SUBTITLES);
        if (subtitlesNode != null) {
            ArrayList<VideoContainer> hardsubsFor = new ArrayList<VideoContainer>();
            String softSubsMimeType = null;
            Element softsubsNode = subtitlesNode.getChild(TAG_SUBTITLES_SOFTSUBS);
            Element hardsubsNode = subtitlesNode.getChild(TAG_SUBTITLES_HARDSUBS);
            if (softsubsNode != null) {
                softSubsMimeType = softsubsNode.getAttributeValue("mime-type");
            }
            boolean hardSubsSupported = true;
            if (hardsubsNode != null) {
                String hardSubsSupportedString = hardsubsNode.getAttributeValue("supported");
                hardSubsSupported = hardSubsSupportedString == null ? true : Boolean.valueOf(hardSubsSupportedString);
                List requiredForNodes = hardsubsNode.getChildren(TAG_SUBTITLES_HARDSUBS_REQUIRED_FOR);
                for (Element requiredForNode : requiredForNodes) {
                    VideoContainer container = VideoContainer.getByFFmpegValue(requiredForNode.getAttributeValue("container"), null);
                    if (container == null) {
                        throw new ProfilesDefinitionException(String.format("Profile %s has unsupported hardsubs container in subtitles definition", profileId));
                    }
                    hardsubsFor.add(container);
                }
            }
            return new SubtitlesConfiguration(softSubsMimeType, hardsubsFor, hardSubsSupported);
        }
        return null;
    }

    private static boolean validateProfile(Profile profile) {
        if (ObjectValidator.isEmpty(profile.getId())) {
            log.error("Profile validation failed: id missing");
            return false;
        }
        if (profile.getContentDirectoryMessageBuilder() == null) {
            log.error("Profile validation failed: ContentDirectoryMessageBuilder missing");
            return false;
        }
        if (profile.getDeviceDescription() == null || ObjectValidator.isEmpty(profile.getDeviceDescription().getFriendlyName()) || ObjectValidator.isEmpty(profile.getDeviceDescription().getModelName())) {
            log.error("Profile validation failed: DeviceDescription missing");
            return false;
        }
        if (ObjectValidator.isEmpty(profile.getName())) {
            log.error("Profile validation failed: name missing");
            return false;
        }
        if (ObjectValidator.isEmpty(profile.getProtocolInfoType())) {
            log.error("Profile validation failed: ProtocolInfo missing");
            return false;
        }
        return true;
    }

    private static void validateXML(String profilesXML) throws ProfilesDefinitionException {
        URL schemaURL = ProfilesDefinitionParser.class.getResource(PROFILES_XSD);
        boolean valid = XmlUtils.validateXML(PROFILES_XSD, schemaURL, profilesXML);
        if (!valid) {
            throw new ProfilesDefinitionException("Profiles XML file is not valid (according to the schema). Check the log.");
        }
    }

    static {
        try {
            COMP_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn(String.format("Cannot get name of the local computer: %s", e.getMessage()));
        }
    }
}

