/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.profile;

import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.serviio.profile.DetectionDefinition;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfilesDefinitionException;
import org.serviio.profile.ProfilesDefinitionParser;
import org.serviio.renderer.RendererManager;
import org.serviio.renderer.entities.Renderer;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileManager {
    private static List<Profile> profiles = new ArrayList<Profile>();
    public static final String DEFAULT_PROFILE_ID = "1";
    private static final String PROFILES_XML_PATH = "/profiles.xml";
    private static final String APP_PROFILES_XML_PATH = "/application-profiles.xml";
    private static final Logger log = LoggerFactory.getLogger(ProfileManager.class);

    public static Profile getProfile(InetAddress clientIPAddress) {
        Renderer renderer = RendererManager.getInstance().getStoredRendererByIPAddress(clientIPAddress);
        return ProfileManager.getProfile(renderer);
    }

    public static Profile getProfile(String clientIPAddress) {
        try {
            return ProfileManager.getProfile(Inet4Address.getByName(clientIPAddress));
        }
        catch (UnknownHostException e) {
            log.warn("Cannot parse IP address for: " + clientIPAddress);
            return ProfileManager.getProfileById(DEFAULT_PROFILE_ID);
        }
    }

    public static Profile getProfile(Renderer renderer) {
        if (renderer != null) {
            return ProfileManager.getProfileById(renderer.getProfileId());
        }
        log.debug("Cannot find stored renderer, using Generic");
        return ProfileManager.getProfileById(DEFAULT_PROFILE_ID);
    }

    public static Profile findProfileByDescription(String friendlyName, String modelName, String modelNumber, String productCode, String serverName, String manufacturer) {
        for (Profile profile : profiles) {
            DetectionDefinition detectionDef = ProfileManager.getDetectionDefinitionByType(profile, DetectionDefinition.DetectionType.UPNP_SEARCH);
            if (detectionDef == null) continue;
            boolean profileMatches = true;
            for (Map.Entry<String, String> entry : detectionDef.getFieldValues().entrySet()) {
                if (entry.getKey().equalsIgnoreCase("FriendlyName")) {
                    profileMatches = profileMatches && ProfileManager.detectionFieldMatches(entry.getValue(), friendlyName);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("ModelName")) {
                    profileMatches = profileMatches && ProfileManager.detectionFieldMatches(entry.getValue(), modelName);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("ModelNumber")) {
                    profileMatches = profileMatches && ProfileManager.detectionFieldMatches(entry.getValue(), modelNumber);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("Manufacturer")) {
                    profileMatches = profileMatches && ProfileManager.detectionFieldMatches(entry.getValue(), manufacturer);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("ProductCode")) {
                    profileMatches = profileMatches && ProfileManager.detectionFieldMatches(entry.getValue(), productCode);
                    continue;
                }
                if (!entry.getKey().equalsIgnoreCase("Server")) continue;
                profileMatches = profileMatches && ProfileManager.detectionFieldMatches(entry.getValue(), serverName);
            }
            if (!profileMatches) continue;
            return profile;
        }
        return null;
    }

    public static Profile findProfileByHeader(Header[] headers) {
        for (Profile profile : profiles) {
            DetectionDefinition detectionDef = ProfileManager.getDetectionDefinitionByType(profile, DetectionDefinition.DetectionType.HTTP_HEADERS);
            if (detectionDef == null) continue;
            for (Map.Entry<String, String> entry : detectionDef.getFieldValues().entrySet()) {
                for (Header header : headers) {
                    if (!entry.getKey().trim().equalsIgnoreCase(header.getName().trim()) || !Pattern.compile(entry.getValue().trim(), 2).matcher(header.getValue().trim()).matches()) continue;
                    return profile;
                }
            }
        }
        return null;
    }

    public static Profile getProfileById(String id) {
        for (Profile profile : profiles) {
            if (!profile.getId().equals(id)) continue;
            return profile;
        }
        return ProfileManager.getProfileById(DEFAULT_PROFILE_ID);
    }

    public static void loadProfiles() {
        profiles = ProfileManager.parseProfilesFromFile(PROFILES_XML_PATH, new ArrayList<Profile>());
        profiles = ProfileManager.parseProfilesFromFile(APP_PROFILES_XML_PATH, profiles);
    }

    public static List<Profile> getAllProfiles() {
        return profiles;
    }

    public static List<Profile> getAllSelectableProfiles() {
        ArrayList<Profile> selectableProfiles = new ArrayList<Profile>();
        for (Profile profile : profiles) {
            if (!profile.isSelectable()) continue;
            selectableProfiles.add(profile);
        }
        return selectableProfiles;
    }

    private static List<Profile> parseProfilesFromFile(String fileName, List<Profile> currentProfiles) {
        InputStream definitionStream = ProfileManager.class.getResourceAsStream(fileName);
        try {
            List<Profile> list = ProfilesDefinitionParser.parseDefinition(definitionStream, currentProfiles);
            return list;
        }
        catch (ProfilesDefinitionException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.closeQuietly(definitionStream);
        }
    }

    private static boolean detectionFieldMatches(String detectionFieldValue, String fieldValue) {
        return fieldValue != null && Pattern.compile(detectionFieldValue, 2).matcher(fieldValue).matches();
    }

    private static DetectionDefinition getDetectionDefinitionByType(Profile profile, DetectionDefinition.DetectionType type) {
        if (profile.getDetectionDefinitions() != null) {
            for (DetectionDefinition dd : profile.getDetectionDefinitions()) {
                if (dd.getType() != type) continue;
                return dd;
            }
        }
        return null;
    }
}

