/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.profile;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.serviio.delivery.resource.transcode.TranscodingConfiguration;
import org.serviio.delivery.subtitles.SubtitlesConfiguration;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.ThumbnailResolution;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.DetectionDefinition;
import org.serviio.profile.H264LevelCheckType;
import org.serviio.profile.ImageResolutions;
import org.serviio.upnp.DeviceDescription;
import org.serviio.upnp.protocol.http.transport.ResourceTransportProtocolHandler;
import org.serviio.upnp.service.contentdirectory.ProtocolInfo;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profile
implements Comparable<Profile> {
    private static final Logger log = LoggerFactory.getLogger(Profile.class);
    public static final String DETECTION_FIELD_SERVER = "Server";
    public static final String DETECTION_FIELD_MODEL_NAME = "ModelName";
    public static final String DETECTION_FIELD_FRIENDLY_NAME = "FriendlyName";
    public static final String DETECTION_FIELD_MODEL_NUMBER = "ModelNumber";
    public static final String DETECTION_FIELD_PRODUCT_CODE = "ProductCode";
    public static final String DETECTION_FIELD_MANUFACTURER = "Manufacturer";
    private String id;
    private String name;
    private boolean alwaysEnableTranscoding;
    private Class<?> contentDirectoryMessageBuilderClass;
    private List<DetectionDefinition> detectionDefinitions;
    private Map<MediaFormatProfile, ProtocolInfo> protocolInfo;
    private DeviceDescription deviceDescription;
    private ResourceTransportProtocolHandler resourceTransportProtocolHandler;
    private String protocolInfoType;
    private ContentDirectoryDefinitionFilter cdDefinitionFilter;
    private DeliveryQuality defaultDeliveryQuality;
    private boolean automaticImageRotation;
    private boolean limitImageResolution;
    private SubtitlesConfiguration subtitlesConfiguration;
    private List<DeliveryQuality> deliveryQualities;
    private boolean selectable;
    private H264LevelCheckType h264LevelCheck;
    private ThumbnailResolution thumbnailsResolution;
    private ImageResolutions allowedImageResolutions;

    public Profile(String id, String name, Class<?> contentDirectoryMessageBuilderClass, ResourceTransportProtocolHandler resourceTransportProtocolHandler, List<DetectionDefinition> detectionDefinitions, Map<MediaFormatProfile, ProtocolInfo> protocolInfo, String protocolInfoType, DeviceDescription deviceDescription, ContentDirectoryDefinitionFilter cdDefinitionFilter, TranscodingConfiguration transcodingConfiguration, TranscodingConfiguration onlineTranscodingConfiguration, TranscodingConfiguration hardSubsTranscodingConfiguration, boolean automaticImageRotation, boolean limitImageResolution, SubtitlesConfiguration subtitlesConfiguration, boolean alwaysEnableTranscoding, boolean selectable, List<DeliveryQuality> deliveryQualities, H264LevelCheckType h264LevelCheck, ThumbnailResolution thumbnailsResolution, ImageResolutions allowedImageResolutions) {
        this.id = id;
        this.name = name;
        this.contentDirectoryMessageBuilderClass = contentDirectoryMessageBuilderClass;
        this.resourceTransportProtocolHandler = resourceTransportProtocolHandler;
        this.detectionDefinitions = detectionDefinitions;
        this.protocolInfo = protocolInfo;
        this.deviceDescription = deviceDescription;
        this.protocolInfoType = protocolInfoType;
        this.cdDefinitionFilter = cdDefinitionFilter;
        this.defaultDeliveryQuality = new DeliveryQuality(DeliveryQuality.QualityType.ORIGINAL, transcodingConfiguration, onlineTranscodingConfiguration, hardSubsTranscodingConfiguration);
        this.automaticImageRotation = automaticImageRotation;
        this.limitImageResolution = limitImageResolution;
        this.subtitlesConfiguration = subtitlesConfiguration;
        this.alwaysEnableTranscoding = alwaysEnableTranscoding;
        this.deliveryQualities = deliveryQualities;
        this.selectable = selectable;
        this.h264LevelCheck = h264LevelCheck;
        this.thumbnailsResolution = thumbnailsResolution;
        this.allowedImageResolutions = allowedImageResolutions;
    }

    public Profile(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public ProtocolInfo getResourceProtocolInfo(MediaFormatProfile mediaFormatProfile) {
        if (this.protocolInfo.containsKey((Object)mediaFormatProfile)) {
            return this.protocolInfo.get((Object)mediaFormatProfile);
        }
        log.warn("Unregistered media format profile requesed, returning null");
        return null;
    }

    public String getMimeType(MediaFormatProfile profile) {
        if (this.protocolInfo.containsKey((Object)profile)) {
            ProtocolInfo pi = this.protocolInfo.get((Object)profile);
            return pi.getMimeType();
        }
        log.warn("Unregistered media format profile's mime-type requesed, returning null");
        return null;
    }

    public boolean hasAnyTranscodingDefinitions() {
        boolean hasDef;
        boolean bl = hasDef = this.getDefaultDeliveryQuality().getTranscodingConfiguration() != null;
        if (!hasDef) {
            for (DeliveryQuality quality : this.getAlternativeDeliveryQualities()) {
                if (quality.getTranscodingConfiguration() == null) continue;
                return true;
            }
        }
        return hasDef;
    }

    public boolean hasAnyOnlineTranscodingDefinitions() {
        boolean hasDef;
        boolean bl = hasDef = this.getDefaultDeliveryQuality().getOnlineTranscodingConfiguration() != null;
        if (!hasDef) {
            for (DeliveryQuality quality : this.getAlternativeDeliveryQualities()) {
                if (quality.getOnlineTranscodingConfiguration() == null) continue;
                return true;
            }
        }
        return hasDef;
    }

    public boolean hasAnyHardSubsTranscodingDefinitions() {
        boolean hasDef;
        boolean bl = hasDef = this.getDefaultDeliveryQuality().getHardSubsTranscodingConfiguration() != null;
        if (!hasDef) {
            for (DeliveryQuality quality : this.getAlternativeDeliveryQualities()) {
                if (quality.getHardSubsTranscodingConfiguration() == null) continue;
                return true;
            }
        }
        return hasDef;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<DetectionDefinition> getDetectionDefinitions() {
        return this.detectionDefinitions;
    }

    public DeviceDescription getDeviceDescription() {
        return this.deviceDescription;
    }

    public Class<?> getContentDirectoryMessageBuilder() {
        return this.contentDirectoryMessageBuilderClass;
    }

    public ResourceTransportProtocolHandler getResourceTransportProtocolHandler() {
        return this.resourceTransportProtocolHandler;
    }

    public String getProtocolInfoType() {
        return this.protocolInfoType;
    }

    public Map<MediaFormatProfile, ProtocolInfo> getProtocolInfo() {
        return this.protocolInfo;
    }

    public ContentDirectoryDefinitionFilter getContentDirectoryDefinitionFilter() {
        return this.cdDefinitionFilter;
    }

    public DeliveryQuality getDefaultDeliveryQuality() {
        return this.defaultDeliveryQuality;
    }

    public boolean isAutomaticImageRotation() {
        return this.automaticImageRotation;
    }

    public boolean isLimitImageResolution() {
        return this.limitImageResolution;
    }

    public SubtitlesConfiguration getSubtitlesConfiguration() {
        return this.subtitlesConfiguration;
    }

    public boolean isAlwaysEnableTranscoding() {
        return this.alwaysEnableTranscoding;
    }

    public List<DeliveryQuality> getAlternativeDeliveryQualities() {
        return Collections.unmodifiableList(this.deliveryQualities);
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public H264LevelCheckType getH264LevelCheck() {
        return this.h264LevelCheck;
    }

    public ThumbnailResolution getThumbnailsResolution() {
        return this.thumbnailsResolution;
    }

    public ImageResolutions getAllowedImageResolutions() {
        return this.allowedImageResolutions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? super.hashCode() : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Profile other = (Profile)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Profile o) {
        if (o != null) {
            if (this.getId().equals(o.getId())) {
                return 0;
            }
            if (o.getId().equals("1")) {
                return 1;
            }
            return this.getName().compareTo(o.getName());
        }
        return -1;
    }
}

