/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.licensing;

import net.padlocksoftware.padlock.license.License;
import net.padlocksoftware.padlock.license.LicenseTest;
import net.padlocksoftware.padlock.license.TestResult;
import net.padlocksoftware.padlock.validator.ValidationParameters;
import net.padlocksoftware.padlock.validator.ValidatorPlugin;
import org.serviio.MediaServer;
import org.serviio.licensing.LicenseProperties;
import org.serviio.licensing.LicensingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionValidatorPlugin
implements ValidatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(VersionValidatorPlugin.class);
    private static final String NAME = "Serviio Version Validator Plugin";
    private static final String DESCRIPTION = "Checks that the license has been released for the samemajor version as the current version.";

    public TestResult validate(License license, ValidationParameters validationParameters) {
        String licenseVersion = license.getProperty(LicenseProperties.VERSION.getName());
        String currentVersion = MediaServer.VERSION;
        boolean passed = false;
        try {
            passed = this.isSupportedVersion(currentVersion, licenseVersion);
            passed = passed || license.getProperty(LicenseProperties.TYPE.getName()).equals(LicensingManager.ServiioLicenseType.UNLIMITED.toString());
        }
        catch (Exception e) {
            log.debug("Could not compute license version validity. Marking license as invalid.", (Throwable)e);
        }
        return new TestResult(new LicenseTest("org.serviio.major_version_test", "Major version check", "Major version check passed", "Major version check failed"), passed);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    private boolean isSupportedVersion(String currentVersion, String licenseVersion) {
        byte licenseMajorVersion;
        byte currentMajorVersion = this.getMajorVersion(currentVersion);
        return currentMajorVersion <= (licenseMajorVersion = this.getMajorVersion(licenseVersion));
    }

    private byte getMajorVersion(String versionString) {
        return Byte.valueOf(versionString.substring(0, versionString.indexOf(".")));
    }
}

