/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.licensing;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.serviio.licensing.InvalidLicenseException;
import org.serviio.licensing.LicenseValidator;
import org.serviio.licensing.ServiioLicense;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensingManager {
    private static final int LICENSE_UPDATER_INTERVAL_SEC = 86400;
    private static final Logger log = LoggerFactory.getLogger(LicensingManager.class);
    private static LicensingManager instance;
    private ServiioLicense license;
    private LicenseValidator validator = new LicenseValidator();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    private LicensingManager() {
        this.updateLicense();
        this.startCheckingThread();
    }

    public static LicensingManager getInstance() {
        if (instance == null) {
            instance = new LicensingManager();
        }
        return instance;
    }

    public ServiioLicense validateLicense(String licenseBody) throws InvalidLicenseException {
        ServiioLicense license = this.validator.validateProvidedLicense(licenseBody);
        return license;
    }

    public synchronized void updateLicense() {
        this.license = new ServiioLicense(null, null, null, null, null, null, null);
    }

    public boolean isProVersion() {
        return this.license.getEdition() == ServiioEdition.PRO;
    }

    public ServiioLicense getLicense() {
        return this.license;
    }

    private void startCheckingThread() {
        Runnable checker = new Runnable(){

            @Override
            public void run() {
                LicensingManager.this.updateLicense();
            }
        };
        this.scheduler.scheduleWithFixedDelay(checker, 86400L, 86400L, TimeUnit.SECONDS);
    }

    public static enum ServiioLicenseType {
        BETA,
        UNLIMITED,
        EVALUATION,
        NORMAL;

    }

    public static enum ServiioEdition {
        FREE,
        PRO;

    }
}

