/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.licensing;

import java.io.IOException;
import org.serviio.licensing.LicenseProvider;
import org.serviio.licensing.LicenseValidator;
import org.serviio.util.FileUtils;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundledLicenseProvider
implements LicenseProvider {
    private static final Logger log = LoggerFactory.getLogger(BundledLicenseProvider.class);
    private static final String BUNDLED_LICENSE_CONTENT = BundledLicenseProvider.readBundledLicense();

    @Override
    public String readLicense() {
        return BUNDLED_LICENSE_CONTENT;
    }

    private static String readBundledLicense() {
        try {
            return StringUtils.readStreamAsString(FileUtils.getStreamFromClasspath("/default.lic", LicenseValidator.class), "UTF-8");
        }
        catch (IOException e) {
            log.warn("Cannot find bundled license");
            return null;
        }
    }
}

