/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.service;

import java.util.List;
import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.AccessGroup;
import org.serviio.licensing.LicensingManager;
import org.serviio.renderer.entities.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessGroupService {
    private static final Logger log = LoggerFactory.getLogger(AccessGroupService.class);

    public static AccessGroup getAccessGroupForRenderer(Renderer renderer) {
        if (renderer == null || renderer.getAccessGroupId() == null) {
            log.debug("Could not find a access group for renderer. Using ANY.");
            return AccessGroup.ANY;
        }
        if (!LicensingManager.getInstance().isProVersion()) {
            return AccessGroup.ANY;
        }
        AccessGroup profile = (AccessGroup)DAOFactory.getAccessGroupDAO().read(renderer.getAccessGroupId());
        if (profile == null) {
            log.debug(String.format("Could not find a access group with id '%s' for renderer. Using ANY.", renderer.getAccessGroupId()));
            return AccessGroup.ANY;
        }
        return profile;
    }

    public static List<AccessGroup> getAccessGroupsForRepository(Long repositoryId) {
        return DAOFactory.getAccessGroupDAO().getAccessGroupsForRepository(repositoryId);
    }

    public static List<AccessGroup> getAccessGroupsForOnlineRepository(Long repositoryId) {
        return DAOFactory.getAccessGroupDAO().getAccessGroupsForOnlineRepository(repositoryId);
    }
}

