/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.SearchIndexer;
import org.serviio.library.search.SearchResult;
import org.serviio.library.search.SearchResultsHolder;
import org.serviio.library.search.ServiioSearchAnalyzer;
import org.serviio.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Searcher {
    private static final Logger log = LoggerFactory.getLogger(Searcher.class);
    private static Map<MediaFileType, List<SearchIndexer.SearchCategory>> categoryMapping = new HashMap<MediaFileType, List<SearchIndexer.SearchCategory>>();
    private MultiReader ireader;
    private DirectoryReader[] subReaders;

    public Searcher(SearchIndexer ... indexers) throws IOException {
        this.subReaders = new DirectoryReader[indexers.length];
        for (int i = 0; i < indexers.length; ++i) {
            IndexWriter writer = indexers[i].getWriter();
            this.subReaders[i] = DirectoryReader.open((IndexWriter)writer, (boolean)true);
        }
        this.ireader = new MultiReader((IndexReader[])this.subReaders, true);
    }

    public List<SearchResultsHolder> search(String term, MediaFileType fileType, int offset, int count) throws IOException {
        log.debug(String.format("Performing search for term '%s'", term));
        this.openReader();
        IndexSearcher isearcher = new IndexSearcher((IndexReader)this.ireader);
        ArrayList<SearchResultsHolder> results = new ArrayList<SearchResultsHolder>();
        for (SearchIndexer.SearchCategory category : categoryMapping.get((Object)fileType)) {
            results.add(this.runSearchForCategory(isearcher, category, fileType, term, offset, count));
        }
        return results;
    }

    public void close() {
        try {
            this.ireader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close index reader", (Throwable)e);
        }
    }

    private SearchResultsHolder runSearchForCategory(IndexSearcher isearcher, SearchIndexer.SearchCategory category, MediaFileType fileType, String term, int offset, int count) throws IOException {
        BooleanQuery termQuery = new BooleanQuery();
        List<String> termParts = this.tokenizeQuery(term);
        for (String termPart : termParts) {
            termQuery.add((Query)new WildcardQuery(new Term("value", termPart.trim() + "*")), BooleanClause.Occur.MUST);
        }
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("fileType", fileType.toString())), BooleanClause.Occur.MUST);
        query.add((Query)new WildcardQuery(new Term("category", category.toString())), BooleanClause.Occur.MUST);
        query.add((Query)termQuery, BooleanClause.Occur.MUST);
        TopDocs result = isearcher.search((Query)query, count + offset);
        ArrayList<SearchResult> foundItems = new ArrayList<SearchResult>();
        List<ScoreDoc> hits = CollectionUtils.getSubList(Arrays.asList(result.scoreDocs), offset, count);
        for (ScoreDoc doc : hits) {
            foundItems.add(SearchResult.fromDoc(isearcher.doc(doc.doc)));
        }
        SearchResultsHolder holder = new SearchResultsHolder();
        holder.setTotalMatched(result.totalHits);
        holder.setCategory(category);
        holder.setItems(foundItems);
        return holder;
    }

    private void openReader() throws IOException {
        boolean changed = false;
        for (int i = 0; i < this.subReaders.length; ++i) {
            DirectoryReader originalReader = this.subReaders[i];
            DirectoryReader updatedIndexReader = DirectoryReader.openIfChanged((DirectoryReader)originalReader);
            if (updatedIndexReader == null) continue;
            changed = true;
            this.subReaders[i] = updatedIndexReader;
        }
        if (changed) {
            this.ireader = new MultiReader((IndexReader[])this.subReaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> tokenizeQuery(String term) throws IOException {
        ArrayList<String> query = new ArrayList<String>();
        ServiioSearchAnalyzer analyzer = new ServiioSearchAnalyzer(Version.LUCENE_44);
        TokenStream tokenStream = analyzer.tokenStream("value", new StringReader(term));
        CharTermAttribute termAtt = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        try {
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                query.add(termAtt.toString());
            }
            tokenStream.end();
        }
        finally {
            tokenStream.close();
            analyzer.close();
        }
        return query;
    }

    static {
        categoryMapping.put(MediaFileType.VIDEO, Arrays.asList(SearchIndexer.SearchCategory.MOVIES, SearchIndexer.SearchCategory.SERIES, SearchIndexer.SearchCategory.EPISODES, SearchIndexer.SearchCategory.FILES, SearchIndexer.SearchCategory.FOLDERS, SearchIndexer.SearchCategory.ONLINE_ITEMS, SearchIndexer.SearchCategory.ONLINE_CONTAINERS));
        categoryMapping.put(MediaFileType.IMAGE, Arrays.asList(SearchIndexer.SearchCategory.FILES, SearchIndexer.SearchCategory.FOLDERS, SearchIndexer.SearchCategory.ONLINE_ITEMS, SearchIndexer.SearchCategory.ONLINE_CONTAINERS));
        categoryMapping.put(MediaFileType.AUDIO, Arrays.asList(SearchIndexer.SearchCategory.ALBUM_ARTISTS, SearchIndexer.SearchCategory.ALBUMS, SearchIndexer.SearchCategory.MUSIC_TRACKS, SearchIndexer.SearchCategory.FILES, SearchIndexer.SearchCategory.FOLDERS, SearchIndexer.SearchCategory.ONLINE_ITEMS, SearchIndexer.SearchCategory.ONLINE_CONTAINERS));
    }
}

