/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.serviio.library.search.SearchIndexCommitter;
import org.serviio.library.search.SearchIndexer;
import org.serviio.library.search.Searcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchManager {
    private static SearchManager instance;
    private static final Logger log;
    private SearchIndexer localIndexer;
    private SearchIndexer onlineIndexer;
    private Searcher searcher;
    private ScheduledExecutorService commitExecutorService = Executors.newSingleThreadScheduledExecutor();

    private SearchManager() throws IOException {
        log.info("Starting up search engine");
        this.localIndexer = new SearchIndexer(false);
        this.onlineIndexer = new SearchIndexer(true);
        this.commitExecutorService.scheduleWithFixedDelay(new SearchIndexCommitter(), 10L, 30L, TimeUnit.SECONDS);
    }

    public static synchronized SearchManager getInstance() {
        if (instance == null) {
            try {
                instance = new SearchManager();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot instantiate search engine: " + e.getMessage(), e);
            }
        }
        return instance;
    }

    public void closeSearchEngine() {
        this.localIndexer.close();
        this.onlineIndexer.close();
        if (this.searcher != null) {
            this.searcher.close();
        }
        this.commitExecutorService.shutdown();
    }

    public SearchIndexer localIndexer() {
        return this.localIndexer;
    }

    public SearchIndexer onlineIndexer() {
        return this.onlineIndexer;
    }

    public Searcher searcher() {
        if (this.searcher == null) {
            try {
                this.searcher = new Searcher(this.localIndexer, this.onlineIndexer);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot initialize searcher, the index is possibly corrupted.", e);
            }
        }
        return this.searcher;
    }

    public synchronized void commitIndex() throws IOException {
        log.debug("Committing search index");
        this.localIndexer().getWriter().commit();
    }

    static {
        log = LoggerFactory.getLogger(SearchManager.class);
    }
}

