/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.serviio.library.search.AbstractSearchMetadata;
import org.serviio.library.search.CommandNotSuitableForSearchMetadataException;
import org.serviio.library.search.SearchMetadata;
import org.serviio.library.search.ServiioSearchAnalyzer;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexer {
    private static final Logger log = LoggerFactory.getLogger(SearchIndexer.class);
    private boolean inMemory;
    private final FieldType indexedTokenizedStored;
    private final FieldType storedNotIndexed;
    private final FieldType storedIndexed;
    private final IndexWriter writer;
    private final Directory directory;

    public SearchIndexer(boolean inMemory) throws IOException {
        this.inMemory = inMemory;
        this.indexedTokenizedStored = new FieldType(TextField.TYPE_STORED);
        this.storedIndexed = new FieldType(StringField.TYPE_STORED);
        this.storedNotIndexed = new FieldType();
        this.storedNotIndexed.setStored(true);
        this.storedNotIndexed.setIndexed(false);
        this.storedNotIndexed.setTokenized(false);
        this.storedNotIndexed.setStoreTermVectors(false);
        this.directory = this.startDirectory();
        this.writer = this.startIndexWriter();
        this.writer.commit();
    }

    public void metadataAdded(SearchMetadata searchMetadata) {
        log.debug(String.format("Adding term '%s' to search index", searchMetadata.getSearchableValue()));
        Definition definition = Definition.instance();
        List<ActionNode> nodes = definition.findNodesForSearchCategory(searchMetadata.getCategory());
        for (ActionNode node : nodes) {
            try {
                this.addItemToIndex(searchMetadata, node, this.writer);
            }
            catch (IOException e) {
                log.warn(String.format("Could not add entry '%s' to search index: %s", searchMetadata.getSearchableValue(), e.getMessage()));
            }
        }
    }

    public void metadataRemoved(SearchCategory category, Long entityId) {
        String indexId = AbstractSearchMetadata.generateIndexId(category, entityId);
        this.metadataRemoved("id", indexId);
    }

    public void metadataRemoved(String field, String value) {
        log.debug(String.format("Removing documents with '%s' of '%s' from search index", field, value));
        try {
            this.writer.deleteDocuments(new Term(field, value));
        }
        catch (IOException e) {
            log.warn(String.format("Could not remove entry with %s '%s' from search index: %s", field, value, e.getMessage()));
        }
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public void deleteIndexEntries() {
        try {
            this.writer.deleteAll();
            this.writer.commit();
        }
        catch (IOException e) {
            log.warn("Failed to delete index entries", (Throwable)e);
        }
    }

    public void close() {
        log.info("Closing search index writer");
        try {
            this.writer.close();
            this.directory.close();
        }
        catch (IOException e) {
            log.warn("Failed to close index writer", (Throwable)e);
        }
    }

    private synchronized void addItemToIndex(SearchMetadata searchMetadata, ActionNode node, IndexWriter writer) throws IOException {
        Document doc = new Document();
        try {
            this.addField(doc, "cdsObjectId", searchMetadata.generateCDSIdentifier(node), this.storedNotIndexed);
            this.addField(doc, "cdsParentId", searchMetadata.generateCDSParentIdentifier(node), this.storedNotIndexed);
            this.addField(doc, "id", searchMetadata.getIndexId(), this.storedIndexed);
            this.addField(doc, "entityId", searchMetadata.getEntityId().toString(), this.storedNotIndexed);
            this.addField(doc, "fileType", searchMetadata.getFileType().toString(), this.storedIndexed);
            this.addField(doc, "category", searchMetadata.getCategory().toString(), this.storedIndexed);
            this.addField(doc, "value", searchMetadata.getSearchableValue(), this.indexedTokenizedStored);
            this.addField(doc, "objectType", searchMetadata.getObjectType().toString(), this.storedNotIndexed);
            if (searchMetadata.getThumbnailId() != null) {
                this.addField(doc, "thumbnailId", searchMetadata.getThumbnailId().toString(), this.storedNotIndexed);
            }
            if (searchMetadata.getContext().size() > 0) {
                this.addField(doc, "context", CollectionUtils.listToCSV(searchMetadata.getContext(), "/", true), this.storedNotIndexed);
            }
            if (searchMetadata.getOnlineRepositoryId() != null) {
                this.addField(doc, "onlineRepoId", searchMetadata.getOnlineRepositoryId().toString(), this.storedIndexed);
            }
            if (writer.getConfig().getOpenMode() == IndexWriterConfig.OpenMode.CREATE) {
                writer.addDocument((Iterable)doc);
            } else {
                writer.updateDocument(new Term("id", searchMetadata.getIndexId()), (Iterable)doc);
            }
        }
        catch (CommandNotSuitableForSearchMetadataException e) {
            // empty catch block
        }
    }

    private void addField(Document doc, String fieldName, String value, FieldType type) {
        Field pathField = new Field(fieldName, value, type);
        doc.add((IndexableField)pathField);
    }

    private IndexWriter startIndexWriter() throws IOException {
        ServiioSearchAnalyzer analyzer = new ServiioSearchAnalyzer(Version.LUCENE_44);
        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_44, (Analyzer)analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        if (IndexWriter.isLocked((Directory)this.directory)) {
            IndexWriter.unlock((Directory)this.directory);
        }
        return new IndexWriter(this.directory, iwc);
    }

    private Directory startDirectory() throws IOException {
        return this.inMemory ? new RAMDirectory() : FSDirectory.open((File)this.getSearchIndexFilePath());
    }

    private File getSearchIndexFilePath() {
        return new File(System.getProperty("serviio.home"), "library/search");
    }

    public static enum SearchCategory {
        MOVIES,
        EPISODES,
        SERIES,
        ALBUMS,
        MUSIC_TRACKS,
        ALBUM_ARTISTS,
        FOLDERS,
        FILES,
        ONLINE_CONTAINERS,
        ONLINE_ITEMS;

    }
}

