/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.AbstractOnlineRecursiveSearchMetadata;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.audio.ListAudioOnlineContentCommand;
import org.serviio.upnp.service.contentdirectory.command.image.ListImageOnlineContentCommand;
import org.serviio.upnp.service.contentdirectory.command.video.ListVideoOnlineContentCommand;
import org.serviio.util.ObjectValidator;

public class OnlineItemSearchMetadata
extends AbstractOnlineRecursiveSearchMetadata {
    public OnlineItemSearchMetadata(Long onlineRepositoryId, Long singleUrlStreamItemId, String title, MediaFileType fileType, Long thumbnailId) {
        this(onlineRepositoryId, singleUrlStreamItemId, title, null, fileType, thumbnailId, false);
    }

    public OnlineItemSearchMetadata(Long onlineRepositoryId, Long itemId, String title, String repositoryName, MediaFileType fileType, Long thumbnailId) {
        this(onlineRepositoryId, itemId, title, repositoryName, fileType, thumbnailId, true);
    }

    private OnlineItemSearchMetadata(Long repositoryId, Long itemId, String title, String repositoryName, MediaFileType fileType, Long thumbnailId, boolean isContainerItem) {
        super(itemId, fileType, ObjectType.ITEMS, SearchIndexer.SearchCategory.ONLINE_ITEMS, title, thumbnailId, repositoryId);
        String recursiveId = this.buildIdForTheHierarchy(repositoryId, itemId, isContainerItem);
        if (fileType == MediaFileType.AUDIO) {
            this.addCommandMapping(ListAudioOnlineContentCommand.class, recursiveId);
        } else if (fileType == MediaFileType.VIDEO) {
            this.addCommandMapping(ListVideoOnlineContentCommand.class, recursiveId);
        } else if (fileType == MediaFileType.IMAGE) {
            this.addCommandMapping(ListImageOnlineContentCommand.class, recursiveId);
        }
        if (isContainerItem && ObjectValidator.isNotEmpty(repositoryName)) {
            this.addToContext(repositoryName);
        }
    }
}

