/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.util.List;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.AbstractRecursiveSearchMetadata;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.audio.ListAudioFoldersByNameCommand;
import org.serviio.upnp.service.contentdirectory.command.image.ListImageFoldersByNameCommand;
import org.serviio.upnp.service.contentdirectory.command.video.ListVideoFoldersByNameCommand;
import org.serviio.util.Tupple;

public class FolderSearchMetadata
extends AbstractRecursiveSearchMetadata {
    public FolderSearchMetadata(Tupple<Long, String> root, List<Tupple<Long, String>> hierarchy, MediaFileType fileType, Long thumbnailId) {
        super(FolderSearchMetadata.getEntityId(hierarchy), fileType, ObjectType.CONTAINERS, SearchIndexer.SearchCategory.FOLDERS, FolderSearchMetadata.getSearchableValue(hierarchy), thumbnailId);
        String recursiveId = this.buildIdForTheHierarchy(root, hierarchy, null);
        if (fileType == MediaFileType.AUDIO) {
            this.addCommandMapping(ListAudioFoldersByNameCommand.class, recursiveId);
        } else if (fileType == MediaFileType.VIDEO) {
            this.addCommandMapping(ListVideoFoldersByNameCommand.class, recursiveId);
        } else if (fileType == MediaFileType.IMAGE) {
            this.addCommandMapping(ListImageFoldersByNameCommand.class, recursiveId);
        }
        this.addContext(root, hierarchy, false);
    }

    private static String getSearchableValue(List<Tupple<Long, String>> hierarchy) {
        return hierarchy.get(hierarchy.size() - 1).getValueB();
    }

    private static Long getEntityId(List<Tupple<Long, String>> hierarchy) {
        if (hierarchy == null || hierarchy.size() == 0) {
            throw new RuntimeException("FolderSearchMetadata needs some folders");
        }
        return hierarchy.get(hierarchy.size() - 1).getValueA();
    }
}

