/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.util.List;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.AbstractRecursiveSearchMetadata;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.audio.ListAudioFoldersByNameCommand;
import org.serviio.upnp.service.contentdirectory.command.image.ListImageFoldersByNameCommand;
import org.serviio.upnp.service.contentdirectory.command.video.ListVideoFoldersByNameCommand;
import org.serviio.util.Tupple;

public class FileSearchMetadata
extends AbstractRecursiveSearchMetadata {
    public FileSearchMetadata(Long mediaItemId, String fileName, Tupple<Long, String> root, List<Tupple<Long, String>> hierarchy, MediaFileType fileType, Long thumbnailId) {
        super(mediaItemId, fileType, ObjectType.ITEMS, SearchIndexer.SearchCategory.FILES, fileName, thumbnailId);
        String recursiveId = this.buildIdForTheHierarchy(root, hierarchy, mediaItemId);
        if (fileType == MediaFileType.AUDIO) {
            this.addCommandMapping(ListAudioFoldersByNameCommand.class, recursiveId);
        } else if (fileType == MediaFileType.VIDEO) {
            this.addCommandMapping(ListVideoFoldersByNameCommand.class, recursiveId);
        } else if (fileType == MediaFileType.IMAGE) {
            this.addCommandMapping(ListImageFoldersByNameCommand.class, recursiveId);
        }
        this.addContext(root, hierarchy, true);
    }
}

