/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.AbstractSearchMetadata;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.video.ListEpisodesForSeriesSeasonCommand;
import org.serviio.upnp.service.contentdirectory.command.video.ListSeasonsForSeriesCommand;
import org.serviio.upnp.service.contentdirectory.command.video.ListSeriesByNameCommand;
import org.serviio.upnp.service.contentdirectory.definition.i18n.BrowsingCategoriesMessages;

public class EpisodeSearchMetadata
extends AbstractSearchMetadata {
    public EpisodeSearchMetadata(Long mediaItemId, Integer season, Long seriesId, String episodeTitle, Long thumbnailId, String seriesName) {
        super(mediaItemId, MediaFileType.VIDEO, ObjectType.ITEMS, SearchIndexer.SearchCategory.EPISODES, episodeTitle, thumbnailId);
        this.addCommandMapping(ListSeriesByNameCommand.class, seriesId);
        this.addCommandMapping(ListSeasonsForSeriesCommand.class, season);
        this.addCommandMapping(ListEpisodesForSeriesSeasonCommand.class, mediaItemId);
        this.addToContext(seriesName);
        this.addToContext(String.format("%s %s", BrowsingCategoriesMessages.getMessage("season", new Object[0]), season));
    }
}

