/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.CommandNotSuitableForSearchMetadataException;
import org.serviio.library.search.SearchIndexer;
import org.serviio.library.search.SearchMetadata;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.NonRecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticContainerNode;

public abstract class AbstractSearchMetadata
implements SearchMetadata {
    private final Long entityId;
    private final MediaFileType fileType;
    private final ObjectType objectType;
    private final SearchIndexer.SearchCategory category;
    private final String searchableValue;
    private final Long thumbnailId;
    private final List<String> context = new ArrayList<String>();
    private final Map<Class<?>, Object> commands = new HashMap();

    public AbstractSearchMetadata(Long mediaItemId, MediaFileType fileType, ObjectType objectType, SearchIndexer.SearchCategory category, String searchableValue, Long thumbnailId) {
        this.entityId = mediaItemId;
        this.fileType = fileType;
        this.searchableValue = searchableValue;
        this.category = category;
        this.objectType = objectType;
        this.thumbnailId = thumbnailId;
    }

    public static String generateIndexId(SearchIndexer.SearchCategory category, Long entityId) {
        return String.format("%s-%s", new Object[]{entityId, category});
    }

    @Override
    public String generateCDSIdentifier(ActionNode node) throws CommandNotSuitableForSearchMetadataException {
        List<ContainerNode> nodesChain = this.getDefinitionNodesChain(node);
        return this.buildIdFromNodesChain(nodesChain);
    }

    @Override
    public String generateCDSParentIdentifier(ActionNode node) throws CommandNotSuitableForSearchMetadataException {
        List<ContainerNode> nodesChain = this.getDefinitionNodesChain(node);
        return this.buildIdFromNodesChain(nodesChain.subList(0, nodesChain.size() - 1));
    }

    @Override
    public String getIndexId() {
        return AbstractSearchMetadata.generateIndexId(this.category, this.entityId);
    }

    @Override
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    public MediaFileType getFileType() {
        return this.fileType;
    }

    @Override
    public SearchIndexer.SearchCategory getCategory() {
        return this.category;
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public Long getThumbnailId() {
        return this.thumbnailId;
    }

    @Override
    public String getSearchableValue() {
        return this.searchableValue;
    }

    @Override
    public List<String> getContext() {
        return this.context;
    }

    @Override
    public Long getOnlineRepositoryId() {
        return null;
    }

    protected List<ContainerNode> getDefinitionNodesChain(ActionNode node) {
        ContainerNode dn;
        ArrayList<ContainerNode> nodesChain = new ArrayList<ContainerNode>();
        for (dn = node; dn != null && dn instanceof ActionNode; dn = (ContainerNode)dn.getParent()) {
            nodesChain.add(dn);
        }
        nodesChain.add(dn);
        Collections.reverse(nodesChain);
        return nodesChain;
    }

    private String buildIdFromNodesChain(List<ContainerNode> nodesChain) throws CommandNotSuitableForSearchMetadataException {
        String generatedId = "";
        for (ContainerNode idNode : nodesChain) {
            if (idNode instanceof ActionNode) {
                ActionNode an = (ActionNode)idNode;
                generatedId = NonRecursiveIdGenerator.generateId(generatedId, an.getIdPrefix(), this.getMetadataAttributeForNode(an).toString());
                continue;
            }
            if (!(idNode instanceof StaticContainerNode)) continue;
            generatedId = generatedId + ((StaticContainerNode)idNode).getId();
        }
        return generatedId;
    }

    private Object getMetadataAttributeForNode(ActionNode an) throws CommandNotSuitableForSearchMetadataException {
        try {
            Class<?> clazz = Class.forName(an.getCommandClass());
            for (Map.Entry<Class<?>, Object> entry : this.commands.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new CommandNotSuitableForSearchMetadataException();
    }

    protected void addCommandMapping(Class<?> commandClass, Object value) {
        this.commands.put(commandClass, value);
    }

    protected void addToContext(String contextField) {
        this.context.add(contextField);
    }
}

