/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import java.util.List;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.AbstractSearchMetadata;
import org.serviio.library.search.CommandNotSuitableForSearchMetadataException;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.RecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;
import org.serviio.util.CollectionUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.Tupple;

public abstract class AbstractRecursiveSearchMetadata
extends AbstractSearchMetadata {
    public AbstractRecursiveSearchMetadata(Long mediaItemId, MediaFileType fileType, ObjectType objectType, SearchIndexer.SearchCategory category, String searchableValue, Long thumbnailId) {
        super(mediaItemId, fileType, objectType, category, searchableValue, thumbnailId);
    }

    @Override
    public String generateCDSParentIdentifier(ActionNode node) throws CommandNotSuitableForSearchMetadataException {
        String objectId = this.generateCDSIdentifier(node);
        String recursiveParentId = RecursiveIdGenerator.getRecursiveParentId(objectId);
        if (recursiveParentId == null) {
            return super.generateCDSParentIdentifier(node);
        }
        return recursiveParentId;
    }

    protected String buildIdForTheHierarchy(Tupple<Long, String> root, List<Tupple<Long, String>> hierarchy, Long leafId) {
        String generatedId = "";
        if (root != null) {
            generatedId = RecursiveIdGenerator.generateRepositoryObjectId(root.getValueA(), null, null);
            if (hierarchy != null && hierarchy.size() > 0) {
                for (Tupple<Long, String> hierarchySegment : hierarchy) {
                    generatedId = RecursiveIdGenerator.generateFolderObjectId(hierarchySegment.getValueA(), generatedId);
                }
            }
            if (leafId != null) {
                generatedId = RecursiveIdGenerator.generateItemObjectId(leafId, generatedId);
            }
        }
        return generatedId;
    }

    protected void addContext(Tupple<Long, String> root, List<Tupple<Long, String>> hierarchy, boolean includeLeaf) {
        if (root != null) {
            this.addToContext(root.getValueB());
            if (ObjectValidator.isNotNullNorEmpty(hierarchy)) {
                int numberOfSegments = includeLeaf ? hierarchy.size() : hierarchy.size() - 1;
                List<Tupple<Long, String>> hierarchyContext = CollectionUtils.getSubList(hierarchy, 0, numberOfSegments);
                for (Tupple<Long, String> hierarchySegment : hierarchyContext) {
                    this.addToContext(hierarchySegment.getValueB());
                }
            }
        }
    }
}

