/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.search;

import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.AbstractSearchMetadata;
import org.serviio.library.search.CommandNotSuitableForSearchMetadataException;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.command.OnlineRecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;

public abstract class AbstractOnlineRecursiveSearchMetadata
extends AbstractSearchMetadata {
    private Long onlineRepositoryId;

    public AbstractOnlineRecursiveSearchMetadata(Long mediaItemId, MediaFileType fileType, ObjectType objectType, SearchIndexer.SearchCategory category, String searchableValue, Long thumbnailId, Long onlineRepositoryId) {
        super(mediaItemId, fileType, objectType, category, searchableValue, thumbnailId);
        this.onlineRepositoryId = onlineRepositoryId;
    }

    @Override
    public String generateCDSParentIdentifier(ActionNode node) throws CommandNotSuitableForSearchMetadataException {
        String objectId = this.generateCDSIdentifier(node);
        String recursiveParentId = OnlineRecursiveIdGenerator.getRecursiveParentId(objectId);
        if (recursiveParentId == null) {
            return super.generateCDSParentIdentifier(node);
        }
        return recursiveParentId;
    }

    protected String buildIdForTheHierarchy(Long containerId, Long leafId, boolean isContainerItem) {
        String generatedId = "";
        if (isContainerItem && containerId != null) {
            generatedId = OnlineRecursiveIdGenerator.generateFolderObjectId(containerId, null, null);
        }
        if (leafId != null) {
            generatedId = OnlineRecursiveIdGenerator.generateItemObjectId(leafId, generatedId, null);
        }
        return generatedId;
    }

    @Override
    public Long getOnlineRepositoryId() {
        return this.onlineRepositoryId;
    }
}

