/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.serviio.library.playlist.AbstractPlaylistParserStrategy;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistType;
import org.serviio.util.ObjectValidator;
import org.serviio.util.XPathUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WplParserStrategy
extends AbstractPlaylistParserStrategy {
    @Override
    public ParsedPlaylist parsePlaylist(byte[] playlist, String playlistLocation) throws CannotParsePlaylistException {
        String content = this.readPlaylistContent(playlist);
        try {
            Node smilNode = XPathUtil.getNode(content, "smil");
            if (smilNode != null) {
                String title = XPathUtil.getNodeValue(smilNode, "head/title");
                if (ObjectValidator.isEmpty(title)) {
                    title = FilenameUtils.getBaseName((String)playlistLocation);
                }
                ParsedPlaylist pl = new ParsedPlaylist(title);
                NodeList mediaNodesList = XPathUtil.getNodeSet(smilNode, "body/seq/media");
                for (Node mediaNode : XPathUtil.getListOfNodes(mediaNodesList)) {
                    pl.addItem(this.getAbsoluteFilePath(mediaNode.getAttributes().getNamedItem("src").getTextContent(), playlistLocation));
                }
                return pl;
            }
            throw new CannotParsePlaylistException(PlaylistType.WPL, playlistLocation, "Cannot find SMIL element");
        }
        catch (XPathExpressionException e) {
            throw new CannotParsePlaylistException(PlaylistType.WPL, playlistLocation, XPathUtil.getParseExceptionMessage(e));
        }
    }

    @Override
    public boolean matches(byte[] playlist, String playlistLocation) {
        String content = this.readPlaylistContent(playlist);
        if (content != null) {
            BufferedReader reader = new BufferedReader(new StringReader(content));
            try {
                String firstLine = reader.readLine();
                return firstLine.startsWith("<?wpl");
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

