/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.io.FilenameUtils;
import org.serviio.library.playlist.AbstractPlaylistParserStrategy;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistType;
import org.serviio.util.ObjectValidator;

public class PlsParserStrategy
extends AbstractPlaylistParserStrategy {
    @Override
    public ParsedPlaylist parsePlaylist(byte[] playlist, String playlistLocation) throws CannotParsePlaylistException {
        String content = this.readPlaylistContent(playlist);
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String inputLine = null;
        ParsedPlaylist pl = new ParsedPlaylist(FilenameUtils.getBaseName((String)playlistLocation));
        try {
            while ((inputLine = reader.readLine()) != null) {
                if (!ObjectValidator.isNotEmpty(inputLine) || !inputLine.startsWith("File")) continue;
                String filePath = inputLine.trim();
                filePath = filePath.substring(filePath.indexOf("=") + 1);
                pl.addItem(this.getAbsoluteFilePath(filePath, playlistLocation));
            }
            return pl;
        }
        catch (IOException e) {
            throw new CannotParsePlaylistException(PlaylistType.PLS, playlistLocation, e.getMessage());
        }
    }

    @Override
    public boolean matches(byte[] playlist, String playlistLocation) {
        String content = this.readPlaylistContent(playlist);
        if (content != null) {
            BufferedReader reader = new BufferedReader(new StringReader(content));
            try {
                String firstLine = reader.readLine();
                return firstLine.startsWith("[playlist]");
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

