/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

public enum PlaylistType {
    ASX{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"asx", "wax", "wvx"};
        }
    }
    ,
    M3U{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"m3u", "m3u8"};
        }
    }
    ,
    PLS{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"pls"};
        }
    }
    ,
    WPL{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"wpl"};
        }
    };


    public abstract String[] supportedFileExtensions();

    public static boolean playlistTypeExtensionSupported(String extension) {
        for (PlaylistType playlistType : PlaylistType.values()) {
            for (String supportedExtension : playlistType.supportedFileExtensions()) {
                if (!extension.equalsIgnoreCase(supportedExtension)) continue;
                return true;
            }
        }
        return false;
    }
}

