/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistParserStrategy;
import org.serviio.library.playlist.PlaylistStrategyFactory;
import org.serviio.util.FileUtils;
import org.serviio.util.HttpClient;
import org.serviio.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistParser {
    private static final Logger log = LoggerFactory.getLogger(PlaylistParser.class);
    private static final int ONLINE_MAX_BYTES_TO_READ = 102400;
    private static PlaylistParser instance;

    private PlaylistParser() {
    }

    public static PlaylistParser getInstance() {
        if (instance == null) {
            instance = new PlaylistParser();
        }
        return instance;
    }

    public ParsedPlaylist parse(String playlistLocation) throws IOException, CannotParsePlaylistException {
        log.debug(String.format("Parsing playlist '%s'", playlistLocation));
        byte[] playlistBytes = this.getPlaylistBytes(playlistLocation);
        PlaylistParserStrategy strategy = PlaylistStrategyFactory.getStrategy(playlistBytes, playlistLocation);
        if (strategy != null) {
            log.debug(String.format("Found a suitable playlist parser strategy: %s", strategy.getClass().getSimpleName()));
            return strategy.parsePlaylist(playlistBytes, playlistLocation);
        }
        log.warn(String.format("Could not find a suitable playlist parser for file '%s', it is either not supported or the file is corrupted.", playlistLocation));
        return null;
    }

    private byte[] getPlaylistBytes(String playlistLocation) throws IOException, FileNotFoundException {
        InputStream is = null;
        int maxLengthToRead = Integer.MAX_VALUE;
        if (HttpUtils.isHttpUrl(playlistLocation)) {
            log.debug("Reading playlist from URL");
            is = HttpClient.getStreamFromURL(playlistLocation);
            maxLengthToRead = 102400;
        } else {
            log.debug("Reading playlist from a local file");
            is = new FileInputStream(playlistLocation);
        }
        return FileUtils.readFileBytes(is, maxLengthToRead);
    }
}

