/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.io.FilenameUtils;
import org.serviio.library.playlist.AbstractPlaylistParserStrategy;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistType;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public class M3UParserStrategy
extends AbstractPlaylistParserStrategy {
    @Override
    public ParsedPlaylist parsePlaylist(byte[] playlist, String playlistLocation) throws CannotParsePlaylistException {
        String content = this.readPlaylistContent(playlist);
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String inputLine = null;
        ParsedPlaylist pl = new ParsedPlaylist(FilenameUtils.getBaseName((String)playlistLocation));
        try {
            while ((inputLine = reader.readLine()) != null) {
                if (!ObjectValidator.isNotEmpty(inputLine) || inputLine.startsWith("#")) continue;
                pl.addItem(this.getAbsoluteFilePath(inputLine.trim(), playlistLocation));
            }
            return pl;
        }
        catch (IOException e) {
            throw new CannotParsePlaylistException(PlaylistType.M3U, playlistLocation, e.getMessage());
        }
    }

    @Override
    public boolean matches(byte[] playlist, String playlistLocation) {
        if (FilenameUtils.isExtension((String)StringUtils.localeSafeToLowercase(playlistLocation), (String[])PlaylistType.M3U.supportedFileExtensions())) {
            return true;
        }
        String content = this.readPlaylistContent(playlist);
        if (content != null) {
            BufferedReader reader = new BufferedReader(new StringReader(content));
            try {
                String firstLine = reader.readLine();
                return firstLine.startsWith("#EXTM3U");
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

