/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.serviio.library.playlist.AbstractPlaylistParserStrategy;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistType;
import org.serviio.util.StringUtils;

public class AsxParserStrategy
extends AbstractPlaylistParserStrategy {
    @Override
    public ParsedPlaylist parsePlaylist(byte[] playlist, String playlistLocation) throws CannotParsePlaylistException {
        String title = FilenameUtils.getBaseName((String)playlistLocation);
        SAXBuilder builder = new SAXBuilder();
        ArrayList<String> files = new ArrayList<String>();
        try {
            Document doc = builder.build((InputStream)new ByteArrayInputStream(playlist));
            Element root = doc.getRootElement();
            if (root != null && StringUtils.localeSafeToLowercase(root.getName()).equals("asx")) {
                List children = root.getChildren();
                block3: for (Element entryNode : children) {
                    if (StringUtils.localeSafeToLowercase(entryNode.getName()).equals("title")) {
                        title = entryNode.getValue();
                    }
                    if (!StringUtils.localeSafeToLowercase(entryNode.getName()).equals("entry")) continue;
                    List refNodes = entryNode.getChildren();
                    for (Element refNode : refNodes) {
                        if (!StringUtils.localeSafeToLowercase(refNode.getName()).equals("ref")) continue;
                        List attributes = refNode.getAttributes();
                        for (Attribute attribute : attributes) {
                            if (!StringUtils.localeSafeToLowercase(attribute.getName()).equals("href")) continue;
                            files.add(attribute.getValue().trim());
                            continue block3;
                        }
                        continue block3;
                    }
                }
                ParsedPlaylist pl = new ParsedPlaylist(title);
                for (String file : files) {
                    pl.addItem(file);
                }
                return pl;
            }
            throw new CannotParsePlaylistException(PlaylistType.ASX, playlistLocation, "Cannot find root ASX element");
        }
        catch (JDOMException e) {
            throw new CannotParsePlaylistException(PlaylistType.ASX, playlistLocation, e.getMessage());
        }
        catch (IOException e) {
            throw new CannotParsePlaylistException(PlaylistType.ASX, playlistLocation, e.getMessage());
        }
    }

    @Override
    public boolean matches(byte[] playlist, String playlistLocation) {
        String content = this.readPlaylistContent(playlist);
        if (content != null) {
            return StringUtils.localeSafeToLowercase(content).indexOf("<asx") > -1;
        }
        return false;
    }
}

