/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.playlist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.serviio.library.playlist.PlaylistParserStrategy;
import org.serviio.util.FileUtils;
import org.serviio.util.HttpUtils;
import org.serviio.util.StringUtils;
import org.serviio.util.UnicodeReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlaylistParserStrategy
implements PlaylistParserStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected String readPlaylistContent(byte[] playlistBytes) {
        try {
            return StringUtils.readReaderAsString(new UnicodeReader(new ByteArrayInputStream(playlistBytes), "UTF-8"), 2000);
        }
        catch (IOException e) {
            this.log.warn("Error reading playlist content.", (Throwable)e);
            return null;
        }
    }

    protected String getAbsoluteFilePath(String filePath, String playlistLocation) {
        if (HttpUtils.isUri(filePath) || FileUtils.isPathAbsoulute(filePath) || filePath.startsWith("\\\\")) {
            return filePath;
        }
        return FilenameUtils.concat((String)FilenameUtils.getFullPath((String)playlistLocation), (String)filePath);
    }
}

