/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.service;

import java.util.ArrayList;
import java.util.List;
import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.OnlineItemService;
import org.serviio.library.service.Service;
import org.serviio.upnp.Device;
import org.serviio.upnp.service.contentdirectory.ContentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineRepositoryService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(OnlineRepositoryService.class);

    public static List<OnlineRepository> getAllRepositories() {
        return DAOFactory.getOnlineRepositoryDAO().findAll();
    }

    public static OnlineRepository getRepository(Long repositoryId) {
        return (OnlineRepository)DAOFactory.getOnlineRepositoryDAO().read(repositoryId);
    }

    public static void deleteRepository(Long repositoryId) {
        DAOFactory.getOnlineRepositoryDAO().delete(repositoryId);
    }

    public static void saveRepositories(List<OnlineRepository> repositories) {
        List<OnlineRepository> existingRepositories = OnlineRepositoryService.getAllRepositories();
        ArrayList<OnlineRepository> repsToRemove = new ArrayList<OnlineRepository>();
        boolean repositoryUpdated = false;
        for (OnlineRepository existingRepository : existingRepositories) {
            if (repositories.contains(existingRepository)) continue;
            log.debug(String.format("Will remove OnlineRepository: %s", existingRepository.toString()));
            repsToRemove.add(existingRepository);
        }
        for (OnlineRepository repoToDelete : repsToRemove) {
            OnlineRepositoryService.deleteRepository(repoToDelete.getId());
            OnlineItemService.removeOnlineContentFromCache(repoToDelete.getRepositoryUrl(), repoToDelete.getId());
            repositoryUpdated = true;
        }
        for (OnlineRepository repository : repositories) {
            if (repository.getId() == null) {
                DAOFactory.getOnlineRepositoryDAO().create(repository);
            } else {
                OnlineRepositoryService.updateRepository(repository);
            }
            repositoryUpdated = true;
        }
        if (repositoryUpdated) {
            log.debug("Online repositories updated, notifying CDS");
            ContentDirectory cds = (ContentDirectory)Device.getInstance().getServiceById("urn:upnp-org:serviceId:ContentDirectory");
            cds.incrementUpdateID();
        }
    }

    public static List<OnlineRepository> getListOfRepositories(List<OnlineRepository.OnlineRepositoryType> repoTypes, MediaFileType mediaType, AccessGroup accessGroup, boolean onlyEnabled) {
        return DAOFactory.getOnlineRepositoryDAO().getRepositories(repoTypes, mediaType, accessGroup, onlyEnabled);
    }

    private static void updateRepository(OnlineRepository repository) {
        OnlineRepository existingRepository = OnlineRepositoryService.getRepository(repository.getId());
        if (repository.getFileType() != existingRepository.getFileType() || repository.getRepoType() != existingRepository.getRepoType() || !repository.getRepositoryUrl().equals(existingRepository.getRepositoryUrl()) || repository.thumbnailChanged(repository.getThumbnailUrl())) {
            OnlineItemService.removeOnlineContentFromCache(existingRepository.getRepositoryUrl(), repository.getId());
        }
        DAOFactory.getOnlineRepositoryDAO().update(repository);
    }
}

