/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.metadata;

import java.util.ArrayList;
import java.util.List;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.metadata.OnlineCachable;
import org.serviio.library.online.metadata.OnlineContainerItem;
import org.serviio.util.ObjectValidator;

public abstract class OnlineResourceContainer<T extends OnlineContainerItem<?>, E extends AbstractUrlExtractor>
implements OnlineCachable {
    private Long onlineRepositoryId;
    private String title;
    private String domain;
    private ImageDescriptor thumbnail;
    private List<T> items = new ArrayList<T>();
    private E usedExtractor;

    public OnlineResourceContainer(Long onlineRepositoryId) {
        this.onlineRepositoryId = onlineRepositoryId;
    }

    public abstract OnlineRepository toOnlineRepository();

    public String getDisplayName(String repositoryName) {
        if (ObjectValidator.isNotEmpty(repositoryName)) {
            return repositoryName;
        }
        if (ObjectValidator.isNotEmpty(this.getDomain())) {
            return String.format("%s [%s]", this.getTitle(), this.getDomain());
        }
        return this.getTitle();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public Long getOnlineRepositoryId() {
        return this.onlineRepositoryId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ImageDescriptor getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(ImageDescriptor thumbnail) {
        this.thumbnail = thumbnail;
    }

    public E getUsedExtractor() {
        return this.usedExtractor;
    }

    public void setUsedExtractor(E usedExtractor) {
        this.usedExtractor = usedExtractor;
    }
}

